# should use generic java rpath;
%def_without java
%set_verify_elf_method unresolved=strict
Name: gnustep-sqlclient
Version: 1.7.0
Release: alt9
Summary: Provide a simple interface to SQL databases for GNUstep applications
License: LGPLv3+
Group: Graphical desktop/GNUstep
Url: http://www.gnustep.org/
Packager: Andrey Cherepanov <cas@altlinux.org>

# http://svn.gna.org/svn/gnustep/libs/sqlclient/trunk/
Source: %name-%version.tar

BuildRequires(pre): rpm-build-java
BuildRequires: gnustep-make-devel gnustep-base-devel
BuildRequires: gnustep-performance-devel /proc
BuildRequires: postgresql-devel libsqlite3-devel
BuildRequires: libMySQL-devel
%if_with java
BuildRequires: java-devel-default
%endif

Requires: lib%name = %version-%release
Requires: gnustep-back

%description
The SQLClient library is designed to provide a simple interface to SQL
databases for GNUstep applications. It does not attempt the sort of
abstraction provided by the much more sophisticated GDL2 library but
rather allows applications to directly execute SQL queries and
statements.

%package -n lib%name
Summary: Shared libraries of GNUstep SQLClient
Group: System/Libraries

%description -n lib%name
The SQLClient library is designed to provide a simple interface to SQL
databases for GNUstep applications. It does not attempt the sort of
abstraction provided by the much more sophisticated GDL2 library but
rather allows applications to directly execute SQL queries and
statements.

This package contains shared libraries of SQLClient.

%package -n lib%name-devel
Summary: Development files of GNUstep SQLClient
Group: Development/Objective-C
Provides: %name-devel = %version-%release
Requires: lib%name = %version-%release
Requires: %name = %version-%release

%description -n lib%name-devel
The SQLClient library is designed to provide a simple interface to SQL
databases for GNUstep applications. It does not attempt the sort of
abstraction provided by the much more sophisticated GDL2 library but
rather allows applications to directly execute SQL queries and
statements.

This package contains shared libraries of SQLClient.

%package doc
Summary: Documentation for GNUstep SQLClient
Group: Development/Documentation
BuildArch: noarch

%description doc
The SQLClient library is designed to provide a simple interface to SQL
databases for GNUstep applications. It does not attempt the sort of
abstraction provided by the much more sophisticated GDL2 library but
rather allows applications to directly execute SQL queries and
statements.

This package contains documentation for SQLClient.

%prep
%setup

%build
. %_datadir/GNUstep/Makefiles/GNUstep.sh

export LD_LIBRARY_PATH=$(dirname $(find %_jvmdir -name libjvm.so) \
	|egrep server)
%autoreconf
%configure \
	--libexecdir=%_libdir \
	--with-postgres-dir=%prefix \
	--with-additional-include=-I%_includedir/pgsql \
%if_with java
%ifarch x86_64
	--with-jre-architecture=amd64 \
%else
	--with-jre-architecture=i386 \
%endif
%endif
	--with-installation-domain=SYSTEM

libSQLClient=$PWD/obj/libSQLClient.so

buildIt() {
	%make_build \
		messages=yes \
		debug=yes \
		strip=no \
		shared=yes \
		CONFIG_SYSTEM_LIBS="$1 -lPerformance -lgnustep-base"
}

buildIt
for i in SQLite MySQL \
%if_with java
	JDBC_libs \
	JDBC \
%endif
	Postgres ECPG
do
	rm -f $(find ./ -name $i -type f)
done
buildIt $libSQLClient
 
%install
. %_datadir/GNUstep/Makefiles/GNUstep.sh

%makeinstall_std messages=yes GNUSTEP_INSTALLATION_DOMAIN=SYSTEM

%files
%doc ChangeLog README
%_libdir/GNUstep

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so

%files doc
%_docdir/GNUstep

%changelog
