%def_disable snapshot

%define ver_major 1.84
%define api_ver 1.0
%define gir_api_ver 1.0
%def_enable doctool
%ifarch ppc64le armh
%def_disable check
%else
%def_disable check
%endif
%def_enable gtk_doc

Name: gobject-introspection
Version: %ver_major.0
Release: alt1

Summary: Introspection system for GObject-based libraries
Group: System/Libraries
License: GPL-2.0-or-later and LGPL-2.0-or-later and MIT
Url: https://live.gnome.org/GObjectIntrospection

Provides: gir-repository = %EVR
Obsoletes: gir-repository

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%endif

%add_python3_path %_libdir/%name/giscanner
#https://bugzilla.altlinux.org/38965
# python3(pkgconfig) provided by giscanner/pkgconfig.py
%filter_from_provides /python3(pkgconfig)/d
%filter_from_requires /python3(distutils.*)/d

%define glib_ver 2.82.0
%define python_ver 3.8

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: /proc meson libgio-devel >= %glib_ver
BuildRequires: flex gtk-doc libcairo-devel libcairo-gobject-devel libffi-devel
BuildRequires: python3-devel >= %python_ver python3(setuptools._distutils)
%{?_enable_doctool:BuildRequires: python3-module-mako python3-module-markdown}

%description
GObject introspection provides tools and libraries to help manage its
common metadata format for representing GObject-based C APIs, designed
for bindings, documentation tools and API verification.

%package x11
Summary: x11-dependent typelibs
Group: System/Libraries
Requires: %name = %EVR

%description x11
This package provides x11-dependent typelibs from %name package.

%package devel
Summary: Libraries and headers for gobject-introspection
Group: Development/C
Requires: %name = %EVR libgio-devel rpm-build-gir
Requires: %name-x11 = %EVR
#Requires: libgirepository%api_ver = %EVR
Requires: libgirepository%api_ver-devel = %EVR
Requires: python3(setuptools._distutils)
Provides: gir-repository-devel = %EVR
Obsoletes: gir-repository-devel

%description devel
GObject introspection provides tools and libraries to help manage its
common metadata format for representing GObject-based C APIs, designed
for bindings, documentation tools and API verification.

This package provides libraries and headers for gobject-introspection.

%package -n libgirepository%api_ver
Summary: GObject Introspection Library (API 1.0)
Group: System/Libraries

%description -n libgirepository%api_ver
This package provides shared GObject Introspection library.

%package -n libgirepository%api_ver-devel
Summary: development package for GObject Introspection library (API 1.0)
Group: Development/C
Requires: libgirepository%api_ver = %EVR

%description -n libgirepository%api_ver-devel
This package provides development files for GObject Introspection library.

%package devel-doc
Summary: Documentation for gobject-introspection
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
GObject introspection provides tools and libraries to help manage its
common metadata format for representing GObject-based C APIs, designed
for bindings, documentation tools and API verification.

This package provides development documentation for
gobject-introspection.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%meson \
    %{subst_enable_meson_feature doctool doctool} \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    -Dpython=%__python3
%meson_build

%install
%meson_install

%check
%__meson_test -v

%files
%dir %_typelibdir/
%_typelibdir/DBus-1.0.typelib
%_typelibdir/DBusGLib-1.0.typelib
%_typelibdir/GIRepository-2.0.typelib
%_typelibdir/GL-1.0.typelib
%_typelibdir/cairo-1.0.typelib
%_typelibdir/fontconfig-2.0.typelib
%_typelibdir/freetype2-2.0.typelib
%_typelibdir/libxml2-2.0.typelib
%_typelibdir/win32-1.0.typelib
%_typelibdir/Vulkan-1.0.typelib

%files x11
%_typelibdir/xfixes-4.0.typelib
%_typelibdir/xft-2.0.typelib
%_typelibdir/xlib-2.0.typelib
%_typelibdir/xrandr-1.3.typelib

%files devel
%_bindir/g-ir-annotation-tool
%_bindir/g-ir-compiler
%_bindir/g-ir-doc-tool
%_bindir/g-ir-generate
%_bindir/g-ir-inspect
%_bindir/g-ir-scanner
%dir %_libdir/%name
%_libdir/%name/giscanner/
%_girdir/
%_datadir/%name-%api_ver
%_datadir/aclocal/introspection.m4
%_man1dir/*.1*

%files -n libgirepository%api_ver
%_libdir/libgirepository-%api_ver.so.*

%files -n libgirepository%api_ver-devel
%_includedir/%name-%api_ver
%_libdir/libgirepository-%api_ver.so
%_pkgconfigdir/%name-%api_ver.pc
%_pkgconfigdir/%name-no-export-%api_ver.pc

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%changelog
