# we are shipping the full contents of src in the data subpackage, which
# contains binary-like things (ELF data for tests, etc)
%global _unpackaged_files_terminate_build 1

%global go_arches %ix86 x86_64 aarch64 %arm mipsel ppc64le riscv64 loongarch64
%global go_root %_prefix/lib/golang
%global golibdir %_libdir/golang

%ifarch x86_64
%global go_hostarch  amd64
%endif
%ifarch %ix86
%global go_hostarch  386
%endif
%ifarch %arm
%global go_hostarch  arm
%endif
%ifarch aarch64
%global go_hostarch  arm64
%endif
%ifarch mipsel
%global go_hostarch  mipsle
%endif
%ifarch ppc64le
%global go_hostarch  ppc64le
%endif
%ifarch riscv64
%global go_hostarch  riscv64
%endif
%ifarch loongarch64
%global go_hostarch loong64
%endif

# Build golang shared objects for stdlib
%ifarch %ix86 x86_64 ppc64le %arm aarch64
%def_enable shared
%else
%def_disable shared
%endif

%ifarch %ix86 x86_64 ppc64le %arm aarch64 riscv64 loongarch64
%def_enable external_linker
%def_enable cgo
%else
%def_disable external_linker
%def_disable cgo
%endif

%def_enable check
%def_enable fail_on_tests

Name:    golang
Version: 1.24.10
Release: alt1
Summary: The Go Programming Language
Group:   Development/Other
License: BSD
URL:     http://golang.org/

Source0: golang-%version.tar
Source1: golang-gdbinit
Patch2:  golang-alt-certs-path.patch
Patch3:  go-never-download-newer-toolchains.patch
Patch101: 0001-avoid-requires-libselinux-utils.patch

ExclusiveArch: %go_arches

%set_verify_elf_method skip
%add_debuginfo_skiplist %go_root
%brp_strip_none %go_root/bin/*
%brp_strip_none %go_root/pkg/*

AutoReq: nocpp

Requires: %name-src = %version-%release
Requires: /proc

BuildRequires(pre): rpm-build-golang rpm-build-python3
BuildRequires: golang >= 1.22.6
BuildRequires: libselinux-utils
BuildRequires: libpcre2-devel
BuildRequires: glibc-devel-static
BuildRequires: /proc
# for tests
BuildRequires: /dev/pts

Provides: go = %version-%release

Provides:  golang-godoc = %version-%release
Obsoletes: golang-godoc < %version-%release

# Due to vet, cover utilities.
Conflicts: golang-tools <= 0-alt1.git7e09e072
# /usr/bin/cover
Conflicts: perl-Devel-Cover

%description
Go is expressive, concise, clean, and efficient. Its concurrency mechanisms
make it easy to write programs that get the most out of multicore and
networked machines, while its novel type system enables flexible and
modular program construction.


%package gdb
Summary:   The Go Runtime support for GDB
Group:     Development/Other
BuildArch: noarch
Requires:  %name = %version-%release
Requires:  gdb
AutoReq: nopython
%add_python3_path %go_root/src/runtime
%add_python3_compile_exclude %go_root/src/runtime
%add_python3_req_skip gdb

%description gdb
The Go Runtime support for GDB.


%package shared
Summary: Golang shared object libraries
Group:   Development/Other

%description shared
%summary.


%package docs
Summary:   Go sources and documentation
Group:     Documentation
BuildArch: noarch
Requires:  %name = %version-%release

%description docs
Go sources and documentation.

%package misc
Summary:   Golang compiler miscellaneous sources
Group:     Development/Other
BuildArch: noarch
Requires:  %name = %version-%release
AutoReqProv: no

%description misc
%summary.

%package tests
Summary:   Golang compiler tests for stdlib
Group:     Development/Other
BuildArch: noarch
Requires:  %name = %version-%release
AutoReqProv: no

%description tests
%summary.

%package src
Summary:   Golang compiler source tree
Group:     Development/Other
BuildArch: noarch
AutoReq: noshell, noshebang

%description src
%summary.

%prep
%setup -q

%patch2 -p1
%patch3 -p1
%patch101 -p1

%build
# go1.5 bootstrapping. The compiler is written in golang.
export GOROOT_BOOTSTRAP=%go_root

# set up final install location
export GOROOT_FINAL=%go_root

export GOHOSTOS=linux
export GOHOSTARCH=%go_hostarch

export GOOS=linux
export GOARCH=%go_hostarch

# use our gcc options for this build, but store gcc as default for compiler
export CC="gcc"
export CC_FOR_TARGET="gcc"
export CFLAGS="$RPM_OPT_FLAGS"
export LDFLAGS="$RPM_LD_FLAGS"
%if_disabled external_linker
export GO_LDFLAGS="-linkmode internal"
%endif
%if_disabled cgo
export CGO_ENABLED=0
%endif

# build
cd src
./make.bash --no-clean -v
cd ..

%if_enabled shared
GOROOT=$PWD PATH="$GOROOT/bin:$PATH" go install -v -buildmode=shared -v -x std
%endif

%check
export GOROOT=$PWD
export PATH="$GOROOT/bin:$PATH"
export CC="gcc"
export CFLAGS="$RPM_OPT_FLAGS"
export LDFLAGS="$RPM_LD_FLAGS"

%if_disabled external_linker
export GO_LDFLAGS="-linkmode internal"
%endif
%if_disabled cgo
export CGO_ENABLED=0
%endif
export GO_TEST_TIMEOUT_SCALE=2

cd src
%if_enabled fail_on_tests
./run.bash --no-rebuild -v -v -v -k
%else
./run.bash --no-rebuild -v -v -v -k ||:
%endif
cd ..

%install
# remove GC build cache
rm -rf pkg/obj/go-build/*

# create the top level directories
mkdir -p -- \
    %buildroot%_bindir \
    %buildroot%go_root \
    %buildroot%_datadir/%name

cp -apfv api bin doc lib pkg src misc test go.env VERSION \
    %buildroot%go_root/

find %buildroot%go_root -exec touch -r $PWD/VERSION "{}" \;

# remove bootstrap files
rm -rfv -- %buildroot%go_root/pkg/bootstrap

# remove the doc Makefile
rm -rfv -- %buildroot%go_root/doc/Makefile

# remove the unnecessary zoneinfo file (Go will always use the system one first)
rm -rfv -- \
    %buildroot%go_root/lib/time

# remove lib/wasm scripts
rm -rfv -- \
    %buildroot%go_root/lib/wasm

%if_enabled shared
mkdir -p %buildroot%golibdir
for file in $(find %buildroot%go_root/pkg/linux_%{go_hostarch}_dynlink  -iname "*.so" ); do
    mv  $file %buildroot%golibdir
    pushd $(dirname $file)
    ln -fs %golibdir/$(basename $file) $(basename $file)
    popd
done
%endif

# add symlinks for binaries.
for z in %buildroot%go_root/bin/*; do
    [ -x "$z" ] || continue
    n="${z##*/}"
    path="$(relative "$z" "%buildroot%_bindir/$n")"
    ln -sv -- "$path" %buildroot%_bindir/$n
done

# https://golang.org/doc/go1.5#moving
# Because the go/types package has now moved into the main repository (see below),
# the vet and cover tools have also been moved. They are no longer maintained in
# the external golang.org/x/tools repository, although (deprecated) source still
# resides there for compatibility with old releases.
for z in cover vet; do
    z="%buildroot%go_root/pkg/tool/linux_%{go_hostarch}/$z"
    [ -x "$z" ] || continue

    n="${z##*/}"
    path="$(relative "$z" "%buildroot%_bindir/$n")"
    ln -sv -- "$path" %buildroot%_bindir/$n
done

# restore the gdb debugging script, needed at runtime by gdb
mkdir -p -- %buildroot%_datadir/%name/gdb
sed \
    -e 's,@GOROOT@,%go_root,g' \
    %SOURCE1 > %buildroot%_datadir/%name/gdb/golang-gdbinit

mkdir -p -- %buildroot%_datadir/%name/src
for n in syscall regexp; do
    mkdir -- %buildroot%_datadir/%name/src/$n

    find %buildroot%go_root/src/$n \
        \( \
            \( -type f -name '*.sh' \) -o \
            \( -type f -name '*.pl' \)    \
        \) \
            -print0 |
            xargs -0 mv -fvt %buildroot%_datadir/%name/src/$n --
done

# ensure these exist and are owned
mkdir -p -- \
    %buildroot%go_path/src/github.com \
    %buildroot%go_path/src/bitbucket.org \
    %buildroot%go_path/src/code.google.com/p \
    %buildroot%go_path/src/golang.org/x \
#

# cleanup
find \
    %buildroot%go_root/src \
    \( \
        \( -type f -name '.gitignore' \) -o \
        \( -type f -name '*.orig'     \) \
    \) \
        -print0 |
    xargs -0 rm -rfv --


# find test files
cwd=$(pwd)
src_list=$cwd/go-src.list
tests_list=$cwd/go-tests.list
rm -f $src_list $tests_list
touch $src_list $tests_list
pushd %buildroot%go_root
find src/ -type d -a \( ! -name testdata -a ! -ipath '*/testdata/*' \) -printf '%%%%dir %go_root/%%p\n' >> $src_list
find src/ ! -type d -a \( ! -ipath '*/testdata/*' -a ! -name '*_test.go' \) -printf '%go_root/%%p\n' >> $src_list
find src/ -type d -a \( -name testdata -o -ipath '*/testdata/*' \) -printf '%%%%dir %go_root/%%p\n' >> $tests_list
find src/ ! -type d -a \( -ipath '*/testdata/*' -o -name '*_test.go' \) -printf '%go_root/%%p\n' >> $tests_list
popd

%files
%_bindir/*
%go_root
%go_path
%exclude %go_root/doc
%exclude %go_root/misc
%exclude %go_root/src
%exclude %go_root/test

%if_enabled shared
%exclude %go_root/pkg/linux_%{go_hostarch}_dynlink
%exclude %golibdir/*.so

%files shared
%go_root/pkg/linux_%{go_hostarch}_dynlink
%golibdir/*.so
%endif

%files gdb
%_datadir/%name/gdb
%go_root/src/runtime/runtime-gdb.py

%files docs
%doc LICENSE PATENTS VERSION
%dir %_datadir/%name
%_datadir/%name/src
%go_root/doc

%files misc
%go_root/misc

%files tests -f go-tests.list
%go_root/test

%files src -f go-src.list
%exclude %go_root/src/runtime/runtime-gdb.py

%changelog
