Summary: Exploring Conway's Game of Life and other cellular automata
Name: golly
Version: 4.2
Release: alt1.1

License: GPLv2
Url: http://golly.sourceforge.net/
Source: %name-%version-src.tar.gz
Source1: %name.sh
Source2: %name.desktop
Group: Education

%add_python_req_skip glife golly

Requires: %name-data = %EVR

# Automatically added by buildreq on Wed Dec 15 2021
# optimized out: at-spi2-atk fontconfig glibc-kernheaders-generic glibc-kernheaders-x86 libImageMagick6-common libat-spi2-core libcairo-gobject libgdk-pixbuf libglvnd-devel libgpg-error libstdc++-devel libwayland-client libwayland-cursor libwayland-egl libwxBase3.1-devel libwxGTK3.1-gl python3 python3-base sh4
BuildRequires: ImageMagick-tools gcc-c++ libGLU-devel libSDL2-devel libwxGTK3.2-devel python3-dev zlib-devel
BuildRequires: python3-module-setuptools

%description
Welcome to Golly, a sophisticated tool for exploring Conway's
Game of Life and other cellular automata.

- Unbounded universe (limited only by memory).
- Fast, memory-efficient conventional algorithm.
- Use hashing to see large patterns evolve at huge time scales.
- Responsive even while generating or garbage collecting.
- Reads RLE, Life 1.05/1.06, dblife, and macrocell formats.
- Can also read common graphic formats: BMP, PNG, GIF, TIFF.
- Includes a state-of-the-art pattern collection.
- Supports other Life-like rules and Wolfram's 1D rules.
- Fast loading of large patterns.
- Paste in patterns from the clipboard.
- Unlimited undo/redo.
- Unbounded zooming out for astronomical patterns.
- Auto fit option keeps a generating pattern within view.
- Full screen option (no menu/status/tool/scroll bars).
- Supports multiple layers, including cloned layers.
- HTML-based help with integrated Life Lexicon.
- Scriptable via Perl or Python.
- User-configurable keyboard shortcuts.
- Free, open source and cross-platform (Windows, Mac, Linux).
- We also provide bgolly, a GUI-less version.

%package data
Summary: Data files for %name, cellular automata emulation software
BuildArch: noarch
Group: Education
%description data
%summary

%prep
%setup -n %name-%version-src

%build
cd gui-wx
%make_build -f makefile-gtk GOLLYDIR=%_datadir/%name

for N in 16 32 48; do convert icons/appicon$N.ico $N.png; done

%install
install -d %buildroot/%_bindir %buildroot/%_datadir/%name
install golly %buildroot/%_bindir/
install bgolly %buildroot/%_bindir/
cp -a Help Patterns Rules Scripts %buildroot/%_datadir/%name/

for N in 16 32 48; do
  install -D gui-wx/$N.png %buildroot%_iconsdir/hicolor/${N}x$N/apps/%name.png
done

install -D %SOURCE2 %buildroot%_desktopdir/%name.desktop

%files
%doc docs/*
%_bindir/*
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_desktopdir/*

%files data
%_datadir/%name

%changelog
