%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict
%ifarch %qt6_qtwebengine_arches
%def_enable gui
%else
%def_disable gui
%endif

Name: gpsbabel
Version: 1.10.0
Release: alt1
Summary: A tool to convert between various formats used by GPS devices
License: GPLv2
Group: Sciences/Geosciences
Url: https://www.gpsbabel.org

VCS: https://github.com/gpsbabel/gpsbabel.git
Source: %name-%version.tar
Source2: gpsbabel.png

Patch1: %name-%version-alt.patch

BuildRequires(pre): rpm-macros-qt6-webengine
BuildRequires: libexpat-devel libusb-devel zlib-devel libminizip-devel gcc-c++
BuildRequires: libshape-devel
BuildRequires: cmake
BuildRequires: qt6-base-devel qt6-tools-devel qt6-serialport-devel qt6-5compat-devel
%if_enabled gui
BuildRequires: qt6-webengine-devel
%endif

%description
GPSBabel converts waypoints, tracks, and routes from one format to another,
whether that format is a common mapping format like Delorme, Streets and
Trips, or even a serial upload or download to a GPS unit such as those from
Garmin and Magellan. By flatting the Tower of Babel that the authors of
various programs for manipulating GPS data have imposed upon us, it returns
to us the ability to freely move our own waypoint data between the programs
and hardware we choose to use.

It contains extensive data manipulation abilities making it a
convenient for server-side processing or as the backend for other
tools.

It does not convert, transfer, send, or manipulate maps. We process
data that may (or may not be) placed on a map, such as waypoints,
tracks, and routes.

%if_enabled gui
%package gui
Group: Sciences/Geosciences
Summary: A tool to convert between various formats used by GPS devices

%description gui
This package contains gui for gpsbabel.
%endif

%prep
%setup
%patch1 -p1

rm -rf zlib shapelib

%build
%add_optflags -D_FILE_OFFSET_BITS=64
%cmake -DGPSBABEL_WITH_LIBUSB=pkgconfig \
	-DGPSBABEL_WITH_SHAPELIB=pkgconfig \
	-DGPSBABEL_WITH_ZLIB=pkgconfig \
	%{?!enabled_gui:-DGPSBABEL_MAPPREVIEW=OFF} \
	%nil
%cmake_build

%install
%cmake_install
install -m 0755 -d %buildroot%_bindir/
install -m 0755 -p %_cmake__builddir/gpsbabel %buildroot%_bindir/

%if_enabled gui
install -m 0755 -p %_cmake__builddir/gui/GPSBabelFE/gpsbabelfe %buildroot%_bindir/
install -m 0755 -d %buildroot%_datadir/gpsbabel
install -m 0644 -p gui/gmapbase.html %buildroot%_datadir/gpsbabel
desktop-file-install \
        --dir %buildroot/%_datadir/applications \
        gui/gpsbabel.desktop
install -m 0755 -d            %buildroot%_datadir/icons/hicolor/256x256/apps/
install -m 0644 -p %SOURCE2 %buildroot%_datadir/icons/hicolor/256x256/apps/
%endif

%find_lang %name --with-qt --all-name

%files
%doc AUTHORS README* intdoc
%_bindir/%name

%if_enabled gui
%files gui -f %name.lang
%doc gui/README*
%_bindir/gpsbabelfe
%_datadir/gpsbabel
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*
%endif

%changelog
