%define _unpackaged_files_terminate_build 1

%define ver_major 48
%define beta %nil
%define namespace GDesktopEnums
%define api_ver 3.0
%def_enable introspection

Name: gsettings-desktop-schemas
Version: %ver_major.0
Release: alt1%beta

Summary: A collection of GSettings schemas
License: LGPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: ftp://ftp.gnome.org/

Vcs: https://gitlab.gnome.org/GNOME/gsettings-desktop-schemas.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz

Requires: %name-data = %EVR

%define gio_ver 2.31.0
Requires(pre): libgio >= %gio_ver

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson libgio-devel >= %gio_ver
%{?_enable_introspection:BuildRequires(pre): rpm-build-gir
BuildRequires: gobject-introspection-devel}

%description
%name contains a collection of GSettings schemas for settings shared by
various components of a desktop.

%package data
Summary: Shared GSettings schemas for the GNOME desktop
Group: Graphical desktop/GNOME
BuildArch: noarch

%description data
This package contains a collection of GSettings schemas for settings
shared by various components of a desktop.

%package devel
Summary: Development package for %name
Group: Development/Other
BuildArch: noarch
Requires: %name = %EVR

%description devel
This package contains development files for %name

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for %name.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for %name.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_bool introspection introspection}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%files

%files data -f %name.lang
%_datadir/glib-2.0/schemas/org.gnome.desktop.a11y.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.a11y.interface.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.a11y.applications.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.a11y.keyboard.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.a11y.magnifier.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.a11y.mouse.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.app-folders.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.background.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.break-reminders.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.calendar.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.datetime.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.default-applications.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.enums.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.input-sources.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.interface.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.system.locale.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.lockdown.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.media-handling.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.peripherals.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.screensaver.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.screen-time-limits.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.session.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.sound.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.thumbnail-cache.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.thumbnailers.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.wm.keybindings.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.wm.preferences.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.system.location.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.system.proxy.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.notifications.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.privacy.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.desktop.search-providers.gschema.xml

%_datadir/GConf/gsettings/gsettings-desktop-schemas.convert
%_datadir/GConf/gsettings/wm-schemas.convert
%doc AUTHORS README NEWS

%files devel
%_includedir/gsettings-desktop-schemas/gdesktop-enums.h
%_datadir/pkgconfig/gsettings-desktop-schemas.pc

%if_enabled introspection
%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir
%endif

%changelog
