%define _name gst-plugins
%define ver_major 1.26
%define api_ver 1.0

%define _gst_datadir %_datadir/gstreamer-%api_ver
%define _gst_libdir %_libdir/gstreamer-%api_ver
%define _gtk_docdir %_datadir/gtk-doc/html

%def_disable doc
# GPL-licensed plugins
%def_enable gpl
%def_disable debug
%def_disable examples
%def_disable check

Name: %_name-ugly%api_ver
Version: %ver_major.4
Release: alt1

Summary: A set of encumbered GStreamer plugins
Group: System/Libraries
License: LGPLv2+
Url: http://gstreamer.freedesktop.org/

Provides: %_name-ugly = %EVR

Requires: gstreamer%api_ver >= %ver_major
Requires: lib%_name%api_ver >= %ver_major

Provides: %_name%api_ver-lame = %EVR
Provides: %_name%api_ver-mad = %EVR

Source: http://gstreamer.freedesktop.org/src/%_name-ugly/%_name-ugly-%version.tar.xz

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ orc liborc-test-devel gst-plugins%api_ver-devel >= %version
BuildRequires: liba52-devel libcdio-devel libid3tag-devel
BuildRequires: libmad-devel libmpeg2-devel liboil-devel libx264-devel
BuildRequires: libopencore-amrnb-devel libopencore-amrwb-devel libdvdread-devel
%{?_enable_doc:BuildRequires: hotdoc gtk-doc gstreamer%api_ver-utils}
%{?_enable_check:BuildRequires: /proc gstreamer%api_ver-utils}

%description
GStreamer Ugly Plug-ins is a set of plug-ins that have good quality
and correct functionality, but distributing them might pose problems.
The license on either the plug-ins or the supporting
libraries might not be how the developers would like.
The code might be widely known to present patent problems.

%package devel-doc
Summary: Development documentation for GStreamer Ugly plugins
Group: Development/Documentation
BuildArch: noarch
Provides: %_name-ugly-devel-doc = %EVR

%description devel-doc
This package contains development documentation for GStreamer Ugly plugin
collection.

%prep
%setup -n %_name-ugly-%version

%build
%meson \
	%{?_enable_check:-Dtests=enabled} \
	%{?_disable_doc:-Ddoc=disabled} \
	%{?_enable_gpl:-Dgpl=enabled} \
	%{?_enable_debug:-Dgst_debug=true}
%nil
%meson_build

%install
%meson_install
%find_lang %_name-ugly-%api_ver

%check
%__meson_test

%files -f %_name-ugly-%api_ver.lang
%_gst_libdir/libgsta52dec.so
#%_gst_libdir/libgstamrnb.so
#%_gst_libdir/libgstamrwbdec.so
%_gst_libdir/libgstasf.so
%{?_enable_gpl:%_gst_libdir/libgstcdio.so
%_gst_libdir/libgstdvdread.so
%_gst_libdir/libgstmpeg2dec.so
%_gst_libdir/libgstx264.so}
%_gst_libdir/libgstdvdlpcmdec.so
%_gst_libdir/libgstdvdsub.so
%_gst_libdir/libgstrealmedia.so
%_datadir/gstreamer-%api_ver/*
%doc AUTHORS NEWS README* RELEASE

%if_enabled doc
%files devel-doc
%_gtk_docdir/%_name-ugly-plugins-%api_ver/*
%endif

%changelog
