%define _unpackaged_files_terminate_build 1

Name: hardinfo2
Version: 2.2.10
Release: alt1.gitda7f31d

Summary: System Information and Benchmark for Linux Systems
License: GPL-2.0-or-later
Group: System/Kernel and hardware
Url: https://www.hardinfo2.org
Vcs: https://github.com/hardinfo2/hardinfo2

Source: %name-%version.tar

# addition tools according to upstream
Requires: lm_sensors3
Requires: sysbench
Requires: udisks2
Requires: dmidecode
Requires: lsscsi
Requires: xdg-utils
Requires: iperf3
Requires: fwupd
Requires: xrandr
Requires: vulkan-tools
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: qt5-base-devel
BuildRequires: libgtk+3-devel
BuildRequires: libcairo-devel
BuildRequires: glib2-devel
BuildRequires: libsoup3.0-devel
BuildRequires: libjson-glib-devel
BuildRequires: glslang-devel
BuildRequires: libdecor-devel
BuildRequires: libvulkan-devel

%description
Hardinfo2 is based on hardinfo, which has not been released >10 years.
Hardinfo2 is the reboot that was needed.

Hardinfo2 offers System Information and Benchmark for Linux Systems.
It is able to obtain information from both hardware and basic software.
It can benchmark your system and compare to other machines online.

%prep
%setup

%build
%cmake -DHARDINFO2_QT5_MOCQT5=1
%cmake_build

%install
%cmake_install
install -D %_builddir/%{name}-%{version}/tools/hardinfo2 %buildroot/%_initdir/%name
%find_lang %name

%post
%post_service %name

%preun
%preun_service %name

%files -f %name.lang
%doc README.md
%_bindir/*
%_desktopdir/%name.desktop
%_datadir/%name
%_iconsdir/hicolor/*/apps/%name.svg
%_man1dir/%{name}*
%_datadir/metainfo/org.hardinfo2.hardinfo2.metainfo.xml
%_libdir/%name
%_unitdir/%name.service
%_initdir/%name

%changelog
