# Spec file for Icecast streaming server
%define _unpackaged_files_terminate_build 1

Name: icecast
Version: 2.4.4
Release: alt2

Summary: Streaming Media Server
License: %gpl2only
Group: System/Servers
Url: http://www.icecast.org

Source0: %name-%version.tar
Source1: %name.init
Source2: %name.logrotate

Source4: %name.chroot.lib
Source5: %name.chroot.conf
Source6: %name.chroot.all

Patch1: %name-%version-alt.patch

BuildRequires(pre): rpm-build-licenses
# Automatically added by buildreq on Mon Jul 06 2009
BuildRequires: gcc-c++ libcurl-devel libspeex-devel libtheora-devel libvorbis-devel libxslt-devel

%description
Icecast is an Internet based broadcasting system based on the Mpeg Layer III
streaming technology. It is, however, not limited to streaming mp3 files.

%prep
%setup -q
%patch1 -p1

%build
%autoreconf
%configure \
	--datadir=%_localstatedir \
	--localstatedir=%_var

%make_build

%install
%make_install DESTDIR=%buildroot install

install -p -m755 -D %SOURCE1 %buildroot%_initdir/%name
install -p -m640 -D %SOURCE2 %buildroot%_sysconfdir/logrotate.d/%name

install -p -m640 -D conf/icecast.xml.dist %buildroot%_sysconfdir/%name.xml
install -p -m644 -D admin/xspf.xsl        %buildroot%_localstatedir/%name/admin/xspf.xsl

mkdir -p %buildroot/var/run/%name
mkdir -p -m750 %buildroot%_localstatedir/%name/logs

mkdir -p %buildroot%_datadir/doc
mv %buildroot%_localstatedir/doc/%name-%version %buildroot%_datadir/doc/%name-%version
mv %buildroot%_datadir/doc/%name/* %buildroot%_datadir/doc/%name-%version/
rmdir %buildroot%_datadir/doc/%name

install -m 0755 -d -- %buildroot%_localstatedir/%name/etc
install -m 0755 -d -- %buildroot%_localstatedir/%name/%_lib
install -p -m 0750 -D -- %SOURCE4 %buildroot%_sysconfdir/chroot.d/%name.lib
install -p -m 0750 -D -- %SOURCE5 %buildroot%_sysconfdir/chroot.d/%name.conf
install -p -m 0750 -D -- %SOURCE6 %buildroot%_sysconfdir/chroot.d/%name.all

%pre
%_sbindir/groupadd -r -f %name &>/dev/null
%_sbindir/useradd -r -g %name -d %_datadir/%name -s /dev/null \
	-c "Icecast Streaming Media Server" -M -n %name &>/dev/null ||:

%post
%_sysconfdir/chroot.d/%name.all
%post_service %name

%preun
%preun_service %name

%files
%_datadir/doc/%name-%version

%attr(750,  root, %name) %dir %_localstatedir/%name
%attr(1770, root, %name) %dir %_localstatedir/%name/logs
%attr(1775, root, %name) %dir /var/run/%name

%config %_sysconfdir/logrotate.d/%name
%config (noreplace) %_sysconfdir/%name.xml
%config %_sysconfdir/chroot.d/%name.*

%_initdir/%name
%_bindir/%name
%_localstatedir/%name

%changelog
