%define oversion %(echo %version | sed -e "s|\\.|_|g")

Name: iozone
Version: 3.506
Release: alt1

Summary: IOzone Filesystem Benchmark
Summary(ru_RU.UTF-8): Эталонный тест файловой подсистемы IOzone

License: Freeware
Group: File tools
Url: http://www.iozone.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source0-url: http://www.iozone.org/src/current/%name%oversion.tar
Source0: %name-%version.tar
Source1: %name-graphs

# for convert doc document to txt
BuildPreReq: catdoc

%description
IOzone is a filesystem benchmark tool. The benchmark generates and
measures a variety of file operations. Iozone has been ported
to many machines and runs under many operating systems.

Iozone is useful for performing a broad filesystem analysis of a vendors
computer platform. The benchmark tests file I/O performance for the following
operations: Read, write, re-read, re-write, read backwards, read strided,
fread, fwrite, random read, pread, mmap, aio_read, aio_write.

%description -l ru_RU.UTF-8
IOzone - это инструмент для эталонного тестирования
производительности файловой подсистемы. Этот тест производит
различные операции над файлами и выполняет тестовые замеры.
Iozone портирована на различные машины и запускается под многими
операционными системами.

Iozone полезна для выполнения обширного анализа файловых подсистем
поставщиков компьютерных платформ. Этот тест исследует
производительность файлового ввода-вывода для следующих операций:
чтение, запись, повторное чтение, повторная запись,
чтение назад, чтение с большим шагом, выполнение функций fread и fwrite,
случайное чтение, выполнение pread, mmap, aio_read, aio_write

Запускайте iozone-graphs для получения графиков в каталоге,
расположенном на тестируемой файловой системе. Учтите, что в ходе тестирования
будет занято до 550 мегабайт, и результаты тестирования будут записаны
в текущем каталоге. Также можно указать iozone-graphs файл, полученный
в результате выполнения любым способом iozone -a.
ВНИМАНИЕ! Тест может выполняться десятки минут, столько требуется для
передачи нескольких десятков гигабайт.

%prep
%setup

%build
cd src/current
# Forgot to mention.  If you have Little Endian 64bit compiler,
# then the make target for linux-AMD64 should work fine,
# and produce a 64 bit version. :-)
%ifarch x86_64 aarch64 riscv64 %e2k
%make_build linux-AMD64
%else
%ifarch ppc64le
%make_build linux-powerpc64
%else
%ifarch armh
%make_build linux-arm
%else
%make_build linux
%endif
%endif
%endif

%install
cd src/current
%define iozonebin %buildroot%_bindir
install -D -m755 %name %iozonebin/%name
install -D -m755 %SOURCE1 %iozonebin/%name-graphs
install -D -m755 gengnuplot.sh %iozonebin/%name-gnuplot.sh

install -D gnu3d.dem %buildroot%_datadir/%name/gnu3d.dem

cd ../../docs
install -D iozone.1 %buildroot%_man1dir/iozone.1
catdoc Run_rules.doc >Run_rules.txt

%files
%doc src/current/Gnuplot.txt docs/IOzone_msword_98.pdf docs/Run_rules.txt
%_bindir/iozone
%_bindir/iozone-graphs
%_bindir/iozone-gnuplot.sh
%_man1dir/*
%_datadir/%name/

%changelog
