Name: ipmitool
Summary: ipmitool - Utility for IPMI control
Version: 1.8.19
Release: alt1
License: BSD
URL: http://ipmitool.sourceforge.net/
Group: System/Kernel and hardware
Source: %name-%version.tar
# http://www.iana.org/assignments/enterprise-numbers.txt
Source1: enterprise-numbers
Patch0: %name-%version-alt.patch

BuildRequires: libssl-devel libreadline-devel libncurses-devel wget

%description
This package contains a utility for interfacing with devices that support
the Intelligent Platform Management Interface specification.  IPMI is
an open standard for machine health, inventory, and remote power control.

This utility can communicate with IPMI-enabled devices through either a
kernel driver such as OpenIPMI or over the RMCP LAN protocol defined in
the IPMI specification.  IPMIv2 adds support for encrypted LAN
communications and remote Serial-over-LAN functionality.

It provides commands for reading the Sensor Data Repository (SDR) and
displaying sensor values, displaying the contents of the System Event
Log (SEL), printing Field Replaceable Unit (FRU) information, reading and
setting LAN configuration, and chassis power control.

%prep
%setup
%patch0 -p1
cp -f %SOURCE1 ./

%build
touch NEWS

%autoreconf
# --disable-dependency-tracking speeds up the build
# --enable-file-security adds some security checks
%configure --disable-dependency-tracking --enable-file-security --disable-intf-free

%make_build

%install
make DESTDIR=%buildroot install
install -pD -m755 contrib/bmclanconf %buildroot%_sbindir/

%files
%_bindir/*
%_sbindir/*
%doc %_mandir/man1/*
%doc %_mandir/man8/*
%doc %_datadir/doc/ipmitool/*
%_datadir/%name
%_datadir/misc/enterprise-numbers

%changelog
