%define _unpackaged_files_terminate_build 1

%define itkver 5.4

Name: itk
Version: %itkver.3
Release: alt1

Group: System/Libraries
Summary: N-dimensional scientific image processing, segmentation, registration
License: Apache-2.0
Url: https://itk.org
VCS: https://github.com/InsightSoftwareConsortium/ITK.git

# https://github.com/InsightSoftwareConsortium/ITK
Source: %name-%version.tar

# Modules generated by update-remote-modules.sh
Source100: %name-%version-AdaptiveDenoising.tar
Source101: %name-%version-AnalyzeObjectLabelMap.tar
Source102: %name-%version-AnisotropicDiffusionLBR.tar
Source103: %name-%version-BioCell.tar
Source104: %name-%version-BoneEnhancement.tar
Source105: %name-%version-BoneMorphometry.tar
Source106: %name-%version-BSplineGradient.tar
Source107: %name-%version-Cleaver.tar
Source108: %name-%version-Cuberille.tar
Source109: %name-%version-FastBilateral.tar
Source110: %name-%version-FixedPointInverseDisplacementField.tar
Source111: %name-%version-FPFH.tar
Source112: %name-%version-GenericLabelInterpolator.tar
Source113: %name-%version-GrowCut.tar
Source114: %name-%version-HASI.tar
Source115: %name-%version-HigherOrderAccurateGradient.tar
Source116: %name-%version-IOFDF.tar
Source117: %name-%version-IOMeshSTL.tar
Source118: %name-%version-IOMeshSWC.tar
Source119: %name-%version-IOOpenSlide.tar
Source120: %name-%version-IOScanco.tar
Source121: %name-%version-IOTransformDCMTK.tar
Source122: %name-%version-IsotropicWavelets.tar
Source123: %name-%version-LabelErodeDilate.tar
Source124: %name-%version-LesionSizingToolkit.tar
Source125: %name-%version-MeshNoise.tar
Source126: %name-%version-MeshToPolyData.tar
Source127: %name-%version-MGHIO.tar
Source128: %name-%version-MinimalPathExtraction.tar
Source129: %name-%version-Montage.tar
Source130: %name-%version-MorphologicalContourInterpolation.tar
Source131: %name-%version-MultipleImageIterator.tar
Source132: %name-%version-ParabolicMorphology.tar
Source133: %name-%version-PerformanceBenchmarking.tar
Source134: %name-%version-PhaseSymmetry.tar
Source135: %name-%version-PolarTransform.tar
Source136: %name-%version-PrincipalComponentsAnalysis.tar
Source137: %name-%version-RANSAC.tar
Source138: %name-%version-RLEImage.tar
Source139: %name-%version-RTK.tar
Source140: %name-%version-Shape.tar
Source141: %name-%version-SimpleITKFilters.tar
Source142: %name-%version-SkullStrip.tar
Source143: %name-%version-SmoothingRecursiveYvvGaussianFilter.tar
Source144: %name-%version-SplitComponents.tar
Source145: %name-%version-Strain.tar
Source146: %name-%version-SubdivisionQuadEdgeMeshFilter.tar
Source147: %name-%version-TextureFeatures.tar
Source148: %name-%version-Thickness3D.tar
Source149: %name-%version-TubeTK.tar
Source150: %name-%version-TwoProjectionRegistration.tar
Source151: %name-%version-Ultrasound.tar
Source152: %name-%version-VariationalRegistration.tar
Source153: %name-%version-VkFFTBackend.tar
Source154: %name-%version-WebAssemblyInterface.tar

Patch1: itk-5.4.2-alt-RTK.patch
Patch2: %name-5.1.2-VariationalRegistration.patch
Patch3: itk-5.4.2-alt-PerformanceBenchmarking.patch
Patch4: itk-5.4.2-alt-WebAssemblyInterface.patch
Patch5: itk-5.4.2-alt-Cleaver.patch
Patch6: itk-5.4.2-alt-VkFFTBackend.patch
Patch7: itk-5.4.2-alt-BioCell.patch
Patch8: itk-5.4.2-upstream-LesionSizingToolkit.patch
Patch9: itk-5.4.2-alt-netlib.patch

BuildRequires(pre): rpm-build-cmake
BuildRequires: castxml
BuildRequires: cleaver-devel
BuildRequires: cli11-devel
BuildRequires: cmake
BuildRequires: dcmtk
BuildRequires: eigen3-devel
BuildRequires: gcc-c++
BuildRequires: gdcm-devel
BuildRequires: graphviz
BuildRequires: jsoncpp-devel
BuildRequires: libblas-devel
BuildRequires: libcbor-devel
BuildRequires: libcpp-base64-devel
BuildRequires: libdouble-conversion-devel
BuildRequires: libexpat-devel
BuildRequires: libfftw3-devel
BuildRequires: libgmock-devel
BuildRequires: libgtest-devel
BuildRequires: libhdf5-devel
BuildRequires: libjpeg-devel
BuildRequires: liblapack-devel
BuildRequires: liblpsolve-devel
BuildRequires: libminc-devel
BuildRequires: libnetcdf-devel
BuildRequires: libniftilib-devel
BuildRequires: libnumpy-py3-devel
BuildRequires: libpng-devel
BuildRequires: libtiff-devel
BuildRequires: libvtk-devel
BuildRequires: libvxl-devel
BuildRequires: libXext-devel
BuildRequires: libxml2-devel
BuildRequires: ocl-icd-devel
BuildRequires: opencl-headers
BuildRequires: rang-devel
BuildRequires: rapidjson-devel
BuildRequires: zlib-devel
%ifnarch ppc64le
# VkFFT currently fails compilation on ppc64le
# with options other than gcc++11
# https://github.com/DTolm/VkFFT/issues/51
BuildRequires: VkFFT-devel
%endif

%define _description \
The Insight Toolkit (ITK) is an open-source, cross-platform toolkit for \
N-dimensional scientific image processing, segmentation, and registration. \
Segmentation is the process of identifying and classifying data found in a  \
digitally sampled representation. Typically the sampled representation is an  \
image acquired from such medical instrumentation as CT or MRI scanners. \
Registration is the task of aligning or developing correspondences between \
data. For example, in the medical environment, a CT scan may be aligned with  \
a MRI scan in order to combine the information contained in both.

%description
%_description

%package -n lib%name%itkver
Summary: Shared libraries for ITK
Group: System/Libraries

%description -n lib%name%itkver
This package contains ITK shared libraries.
%_description

%package -n lib%name-devel
Summary: Development files for ITK
Group: Development/C++
Provides: lib%name-glue-devel = %EVR
Conflicts: lib%name-glue-devel < %EVR
Obsoletes: lib%name-glue-devel < %EVR
Requires: lib%name%itkver = %EVR
Requires: lib%name%itkver-glue = %EVR
Requires: %name-testdriver = %EVR
# Following dependencies are duplicates from build dependencies
Requires: libgtest-devel
Requires: libgmock-devel
Requires: eigen3-devel
Requires: gdcm-devel
Requires: libfftw3-devel
Requires: libXext-devel
Requires: libxml2-devel
Requires: libnetcdf-devel
Requires: libvtk-devel
Requires: libvxl-devel
Requires: ocl-icd-devel
Requires: libcbor-devel

%description -n lib%name-devel
This package contains development files for ITK.
%_description

%package testdriver
Summary: Test driver for ITK
Group: Development/Tools
Requires: lib%name%itkver = %EVR

%description testdriver
This package contains test driver for ITK.
%_description

%package examples
Summary: Examples for ITK
Group: Development/Tools
Requires: lib%name%itkver = %EVR

%description examples
This package contains source code of ITK examples.
%_description

%package doc
Summary: Documentation for ITK
Group: Documentation
BuildArch: noarch

%description doc
This package contains documentation for ITK.
%_description

%package -n lib%name%itkver-glue
Summary: Shared libraries for ITK-VTK bindings
Group: System/Libraries

%description -n lib%name%itkver-glue
This package contains shared libraries for VTK bindings to ITK.
%_description

%prep
%setup -a100 -a101 -a102 -a103 -a104 -a105 -a106 -a107 -a108 -a110 -a111 -a112 -a113 -a114 -a115 -a116 -a117 -a118 -a119 -a120 -a121 -a122 -a123 -a124 -a125 -a126 -a127 -a128 -a129 -a130 -a131 -a132 -a133 -a134 -a135 -a136 -a137 -a138 -a139 -a140 -a141 -a142 -a143 -a144 -a145 -a146 -a147 -a148 -a149 -a150 -a151 -a152 -a153 -a154

rm -rf \
  Modules/ThirdParty/GDCM/src/gdcm \
  Modules/ThirdParty/VNL/src/vxl \
  #

pushd Modules/Remote/RTK
%patch1 -p1
popd

pushd Modules/Remote/VariationalRegistration
%patch2 -p1
popd

pushd Modules/Remote/PerformanceBenchmarking
%patch3 -p1
popd

pushd Modules/Remote/WebAssemblyInterface
%patch4 -p1
popd

pushd Modules/Remote/Cleaver
%patch5 -p1
popd

pushd Modules/Remote/VkFFTBackend
%patch6 -p1
popd

pushd Modules/Remote/BioCell
%patch7 -p1
popd

pushd Modules/Remote/LesionSizingToolkit
%patch8 -p1
popd

%patch9 -p1

# Save an unbuilt copy of the Example's sources for %%doc
mkdir itk-examples
cp -a Examples itk-examples

# Delete unused third party sources
rm -rf Modules/ThirdParty/Expat/src/
rm -rf Modules/ThirdParty/GDCM/src/
rm -rf Modules/ThirdParty/MINC/src/libminc/
rm -rf Modules/ThirdParty/MINC/src/CMakeLists.txt
rm -rf Modules/ThirdParty/HDF5/src/itkhdf5/
rm -rf Modules/ThirdParty/HDF5/src/CMakeLists.txt
rm -rf Modules/ThirdParty/HDF5/src/README.md
rm -rf Modules/ThirdParty/JPEG/src/itkjpeg/
rm -rf Modules/ThirdParty/JPEG/src/CMakeLists.txt
rm -rf Modules/ThirdParty/PNG/src/itkpng/
rm -rf Modules/ThirdParty/PNG/src/CMakeLists.txt
rm -rf Modules/ThirdParty/TIFF/src/itktiff/
rm -rf Modules/ThirdParty/TIFF/src/CMakeLists.txt
rm -rf Modules/ThirdParty/ZLIB/src/itkzlib/
rm -rf Modules/ThirdParty/ZLIB/src/CMakeLists.txt
rm -rf Modules/ThirdParty/VNL/src/
rm -rf Modules/ThirdParty/DoubleConversion/src
rm -rf Modules/ThirdParty/GoogleTest/src

%build
%ifarch aarch64 ppc64le
# limit build jobs on aarch64 and ppc64le to prevent resources exhaustion
if [ %__nprocs -gt 8 ] ; then
	export NPROCS=8
fi
%endif
# XXX: itk-examples (ex-Examples) for some reason are linked with the build
# artifact dir in the runpath, so we pass -DCMAKE_SKIP_RPATH=ON.
# remote modules go last
%cmake -Wno-dev \
       %_cmake_skip_rpath \
       -DSYSCONF_INSTALL_DIR=%_sysconfdir \
       -DSHARE_INSTALL_PREFIX:PATH="%_datadir" \
       -DCMAKE_BUILD_TYPE:STRING="RelWithDebInfo" \
       -DCMAKE_VERBOSE_MAKEFILE=ON \
       -DCMAKE_CXX_FLAGS:STRING="-std=gnu++14 %optflags" \
       -DBUILD_SHARED_LIBS:BOOL=ON \
       -DBUILD_TESTING=OFF \
       -DBUILD_EXAMPLES:BOOL=OFF \
       -DBUILD_DOCUMENTATION:BOOL=OFF \
       -DITK_BUILD_DEFAULT_MODULES:BOOL=ON \
       -DITK_WRAP_PYTHON:BOOL=OFF \
       -DITK_INSTALL_LIBRARY_DIR=%_lib/ \
       -DITK_INSTALL_INCLUDE_DIR=include/%name \
       -DITK_INSTALL_PACKAGE_DIR=%_lib/cmake/%name/ \
       -DITK_INSTALL_RUNTIME_DIR:PATH=%_bindir \
       -DITK_INSTALL_DOC_DIR=share/doc/%name/ \
       -DITK_USE_KWSTYLE:BOOL=OFF \
       -DITK_FORBID_DOWNLOADS=ON \
       -DModule_ITKReview:BOOL=ON \
       -DITK_USE_SYSTEM_LIBRARIES:BOOL=ON \
       -DITK_USE_FFTWD=ON \
       -DITK_USE_FFTWF=ON \
       -DITK_USE_SYSTEM_DCMTK=ON \
       -DITK_USE_SYSTEM_EXPAT=ON \
       -DITK_USE_SYSTEM_FFTW=ON \
       -DITK_USE_SYSTEM_GDCM=ON \
       -DITK_USE_SYSTEM_MINC=ON \
       -DITK_USE_SYSTEM_HDF5=ON \
       -DITK_USE_SYSTEM_JPEG=ON \
       -DITK_USE_SYSTEM_PNG=ON \
       -DITK_USE_SYSTEM_TIFF=ON \
       -DITK_USE_SYSTEM_ZLIB=ON \
       -DITK_USE_SYSTEM_VXL=ON \
       -DITK_USE_SYSTEM_DOUBLECONVERSION=ON \
       -DModule_ITKVtkGlue:BOOL=ON \
       -DModule_ITKIOPNG:BOOL=ON \
       -DModule_ITKDCMTK:BOOL=ON \
       -DModule_ITKIODCMTK:BOOL=ON \
       -DITKV4_COMPATIBILITY:BOOL=ON \
       -DModule_ITKDeprecated:BOOL=ON \
       -DRTK_INSTALL_NO_EXECUTABLES:BOOL=ON \
       -DModule_AdaptiveDenoising:BOOL=ON \
       -DModule_AnalyzeObjectLabelMap:BOOL=ON \
       -DModule_AnisotropicDiffusionLBR:BOOL=ON \
       -DModule_BioCell:BOOL=ON \
       -DModule_BoneEnhancement:BOOL=ON \
       -DModule_BoneMorphometry:BOOL=ON \
       -DModule_BSplineGradient:BOOL=ON \
       -DModule_Cleaver:BOOL=ON \
       -DModule_Cuberille:BOOL=ON \
       -DModule_NeuralNetworks:BOOL=ON \
       -DModule_FixedPointInverseDisplacementField:BOOL=ON \
       -DModule_FPFH:BOOL=ON \
       -DModule_GenericLabelInterpolator:BOOL=ON \
       -DModule_GrowCut:BOOL=ON \
       -DModule_HASI:BOOL=ON \
       -DModule_HigherOrderAccurateGradient:BOOL=ON \
       -DModule_IOFDF:BOOL=ON \
       -DModule_IOMeshSTL:BOOL=ON \
       -DModule_IOMeshSWC:BOOL=ON \
       -DModule_IOOpenSlide:BOOL=ON \
       -DModule_IOScanco:BOOL=ON \
       -DModule_IOTransformDCMTK:BOOL=ON \
       -DModule_IsotropicWavelets:BOOL=ON \
       -DModule_LabelErodeDilate:BOOL=ON \
       -DModule_LesionSizingToolkit:BOOL=ON \
       -DModule_MeshNoise:BOOL=ON \
       -DModule_MeshToPolyData:BOOL=ON \
       -DModule_MGHIO:BOOL=ON \
       -DModule_MinimalPathExtraction:BOOL=ON \
       -DModule_Montage:BOOL=ON \
       -DModule_MorphologicalContourInterpolation:BOOL=ON \
       -DModule_MultipleImageIterator:BOOL=ON \
       -DModule_ParabolicMorphology:BOOL=ON \
       -DModule_PerformanceBenchmarking:BOOL=ON \
       -DModule_PhaseSymmetry:BOOL=ON \
       -DModule_PolarTransform:BOOL=ON \
       -DModule_PrincipalComponentsAnalysis:BOOL=ON \
       -DModule_RANSAC:BOOL=ON \
       -DModule_RLEImage:BOOL=ON \
       -DModule_RTK:BOOL=ON \
       -DModule_Shape:BOOL=ON \
       -DModule_SimpleITKFilters:BOOL=ON \
       -DModule_SkullStrip:BOOL=ON \
       -DModule_SmoothingRecursiveYvvGaussianFilter:BOOL=ON \
       -DModule_SplitComponents:BOOL=ON \
       -DModule_Strain:BOOL=ON \
       -DModule_SubdivisionQuadEdgeMeshFilter:BOOL=ON \
       -DModule_TextureFeatures:BOOL=ON \
       -DModule_Thickness3D:BOOL=ON \
       -DModule_TubeTK:BOOL=ON \
       -DModule_TwoProjectionRegistration:BOOL=ON \
       -DModule_Ultrasound:BOOL=ON \
       -DModule_VariationalRegistration:BOOL=ON \
       %ifnarch ppc64le
       -DModule_VkFFTBackend:BOOL=ON \
       %else
       -DModule_VkFFTBackend:BOOL=OFF \
       %endif
     -DModule_WebAssemblyInterface:BOOL=ON \
     #

%cmake_build

%install
%cmake_install

# Don't install test driver as example
rm -f %_cmake__builddir/bin/itkTestDriver

install -D -m755 -t %buildroot%_libdir/itk-examples/ %_cmake__builddir/bin/*

%files -n lib%name%itkver
%_libdir/lib*-%itkver.so.*
%exclude %_libdir/libITKVtkGlue-%itkver.so.*

%files -n lib%name-devel
%_libdir/lib*-%itkver.so
%_includedir/%name/
%_libdir/cmake/*

%files testdriver
%_bindir/itkTestDriver

%files examples
%doc itk-examples/Examples/
%_libdir/%name-examples/

%files doc
%doc %_docdir/%name/

%files -n lib%name%itkver-glue
%_libdir/libITKVtkGlue-%itkver.so.*

%changelog
