%def_with doc
%define soname 4

Name: jansson
Version: 2.14
Release: alt4

Summary: C library for encoding, decoding and manipulating JSON data
License: MIT
Group: System/Libraries

Url: https://github.com/akheron/jansson
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
BuildRequires: cmake ctest
BuildRequires(pre): rpm-macros-cmake

%if_with doc
BuildRequires: /usr/bin/sphinx-build
%endif

%description
Jansson is a C library for encoding, decoding and manipulating JSON data.
It features:
 - Simple and intuitive API and data model
 - Comprehensive documentation
 - No dependencies on other libraries
 - Full Unicode support (UTF-8)
 - Extensive test suite

%package -n lib%name%soname
Summary: C library for encoding, decoding and manipulating JSON data
Group: System/Libraries
Conflicts: libjansson < 2.14
Obsoletes: libjansson

%description -n lib%name%soname
Jansson is a C library for encoding, decoding and manipulating JSON data.
It features:
 - Simple and intuitive API and data model
 - Comprehensive documentation
 - No dependencies on other libraries
 - Full Unicode support (UTF-8)
 - Extensive test suite

%package -n lib%name-devel
Summary: C library for encoding, decoding and manipulating JSON data
Group: Development/C
Requires: lib%name%soname = %EVR

%description -n lib%name-devel
Jansson is a C library for encoding, decoding and manipulating JSON data.
It features:
 - Simple and intuitive API and data model
 - Comprehensive documentation
 - No dependencies on other libraries
 - Full Unicode support (UTF-8)
 - Extensive test suite

%prep
%setup
%patch0 -p1

%build
%cmake \
	-DJANSSON_BUILD_SHARED_LIBS=ON \
	-DJANSSON_INSTALL_LIB_DIR=%_libdir \
%if_with doc
	-DJANSSON_BUILD_DOCS=ON \
%endif
	%nil
%cmake_build

%if_with doc
%cmake_build -t doc
%endif

%install
%cmake_install

%check
%ctest

%files -n lib%name%soname
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*
%doc README* LICENSE CHANGES

%files -n lib%name-devel
%_includedir/*.h
%_pkgconfigdir/*
%_libdir/*so
%_libdir/cmake/*
%if_with doc
%doc %_cmake__builddir/doc/html/*
%endif

%changelog
