%define _unpackaged_files_terminate_build 1

Name:       java-atk-wrapper
Version:    0.44.0
Release:    alt1
Summary:    Java ATK Wrapper

License:    LGPL-3.0-or-later
Group: Development/Other
URL:        https://gitlab.gnome.org/GNOME/java-atk-wrapper
Source:    %name-%version.tar
# this is a fedora-specific file
# needed to explain how to use java-atk-wrapper with different java runtimes
Source1:    README.fedora

Patch0: fix-configure-dash-version.patch

BuildRequires(pre): rpm-macros-java
BuildRequires:	gcc-c++
BuildRequires:	clang
BuildRequires:  libatk-devel libatk-gir-devel
BuildRequires:  glib2-devel libgio libgio-devel
BuildRequires:  gtk-builder-convert libgail-devel libgtk+2-devel
BuildRequires:  xprop
BuildRequires:  libgail3-devel libgtk+3-devel libgtk+3-gir-devel
BuildRequires:  at-spi2-atk-devel
BuildRequires:  libat-spi2-core-devel libat-spi2-core-gir-devel
BuildRequires:  gobject-introspection-devel
BuildRequires: imake libXt-devel pkgconfig(dbus-1) xorg-cf-files
BuildRequires: /proc java-devel-default


Requires:   java
Requires:   xprop
Source44: import.info

%description
Java ATK Wrapper is a implementation of ATK by using JNI technic. It
converts Java Swing events into ATK events, and send these events to
ATK-Bridge.

JAW is part of the Bonobo deprecation project. It will replaces the
former java-access-bridge.
By talking to ATK-Bridge, it keeps itself from being affected by the
change of underlying communication mechanism.

%prep
%setup
%patch0 -p2

%build
%autoreconf
%configure \
--with-jardir=%_jnidir \
--with-propertiesdir=%_datadir/%name
%make

%install
%makeinstall_std

install -m 444 %SOURCE1 README.fedora

%check
%make check


%files
%doc AUTHORS COPYING.LESSER NEWS README README.fedora
%_libdir/libatk-wrapper.so
%_jnidir/%name.jar
%_datadir/%name

%changelog
