Epoch: 0
Group: System/Libraries
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: jcommon
Version: 1.0.23
Release: alt1_22jpp11
Summary: JFree Java utility classes
License: LGPLv2+
# Github: https://github.com/jfree/jcommon
# There are no tags which we can use to get sources. See:
#   https://github.com/jfree/jcommon/issues/1
# Source retrieved via:
#  bash getsources.sh 1ea10aa82e30e0d60f57e1c562281a3ac7dd5cdd 1.0.23
Source: %{name}-%{version}.tar.gz
URL: http://www.jfree.org/jcommon
BuildRequires: junit
BuildRequires: maven-local
BuildRequires: maven-plugin-bundle
Requires: jpackage-utils
BuildArch: noarch

Patch0: javadoc-11.patch
Patch1: java17.patch
Source44: import.info

%description
JCommon is a collection of useful classes used by 
JFreeChart, JFreeReport and other projects.

%package javadoc
Group: Development/Documentation
Summary: Javadoc for %{name}
Requires: %{name} = %{?epoch:%epoch:}%{version}-%{release}
Requires: jpackage-utils
BuildArch: noarch

%description javadoc
Javadoc for %{name}.

%description javadoc -l fr
Javadoc pour %{name}.

%prep
%setup -q
%patch0 -b javadoc-11
%patch1 -b java17
find . -name "*.jar" -exec rm -f {} \;
# remove unnecessary dependency on parent POM
%pom_remove_parent
MVN_BUNDLE_PLUGIN_EXTRA_XML="<extensions>true</extensions>
        <configuration>
          <instructions>
            <Bundle-SymbolicName>org.jfree.jcommon</Bundle-SymbolicName>
            <Bundle-Vendor>Fedora Project</Bundle-Vendor>
            <Bundle-Version>%{version}</Bundle-Version>
            <!-- Do not autogenerate uses clauses in Manifests -->
            <_nouses>true</_nouses>
          </instructions>
        </configuration>"
%pom_remove_plugin :maven-gpg-plugin
%pom_remove_plugin :nexus-staging-maven-plugin
%pom_remove_plugin :cobertura-maven-plugin
%pom_remove_plugin :maven-site-plugin
%pom_add_plugin org.apache.felix:maven-bundle-plugin . "$MVN_BUNDLE_PLUGIN_EXTRA_XML"
# Change to packaging type bundle so as to be able to use it
# as an OSGi bundle.
%pom_xpath_set "pom:packaging" "bundle"
# temporary while java 11 is being bootstrapped to become the default
# undo javadoc-11.patch while javac is still 1.8.0
if [ "`javac -version 2>&1 | cut -d_ -f 1`" = "javac 1.8.0" ]; then
  sed -i -e /maven.compiler.release/d pom.xml
fi

%build
%mvn_build -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8

%install
%mvn_install

%files -f .mfiles
%doc LICENSE README.md

%files javadoc -f .mfiles-javadoc

%changelog
