Name: keepassxc
Version:  2.7.10
Release:  alt3

Summary: KeePassXC Password Safe - light-weight cross-platform password manager
License: GPLv2+
Group: File tools

Url: http://www.keepassxc.org/
#Source: https://github.com/keepassxreboot/keepassxc/releases/download/%version/%name-%version-src.tar.xz
Source: %name-%version.tar
# to update the translation (may require creating an account on transifex and joining the project):
# - either go to https://www.transifex.com/keepassxc/keepassxc/language/ru/ and "download for use", category "master"
# - or use transifex client `tx pull` accordingly
Source1: keepassxc_ru.ts

Patch1: alt-add-chromium-gost-support-for-browser-integrations.patch

%def_with yubikey
# requires asciidoctor
%def_enable docs
%def_without asan

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake ctest gcc-c++
%if_with asan
BuildRequires: liblsan-devel-static
%endif
BuildRequires: qt5-base-devel >= 5.12.0 qt5-tools-devel >= 5.12.0 qt5-svg-devel
BuildRequires: libbotan-devel >= 2.19
BuildRequires: libargon2-devel
BuildRequires: libsodium-devel
BuildRequires: zlib-devel >= 1.2.0
BuildRequires: libqrencode4-devel
BuildRequires: libreadline-devel
BuildRequires: libminizip-devel
# Optional for Auto-Type on X11/Linux:
BuildRequires: libXi-devel, libXtst-devel, qt5-x11extras-devel
# Optional for YubiKey support
%if_with yubikey
BuildRequires: libyubikey-devel
BuildRequires: libykpers-1-devel
BuildRequires: libpcsclite-devel
BuildRequires: libusb-devel
%endif
%if_enabled docs
BuildRequires: asciidoctor
%endif

%description
KeePassXC is a community fork of KeePassX, a native cross-platform port of
KeePass Password Safe, with the goal to extend and improve it with new features
and bugfixes to provide a feature-rich, fully cross-platform and modern
open-source password manager.

%prep
%setup
%patch1 -p1
%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -name '*.cpp' -o -name '*.h' | xargs sed -ri 's,^\xEF\xBB\xBF,,'
%endif
# install fresh translation
cp -v %SOURCE1 share/translations/keepassxc_ru.ts

%build
# LTO is not supported yet, see https://github.com/keepassxreboot/keepassxc/issues/5801
%define optflags_lto %{nil}

%cmake \
  -DWITH_TESTS=ON \
  -DWITH_XC_BROWSER=ON \
  -DWITH_XC_BROWSER_PASSKEYS=ON \
  -DWITH_XC_PASSKEYS=ON \
  -DWITH_XC_NETWORKING=ON \
  -DWITH_XC_AUTOTYPE=ON \
  -DWITH_XC_SSHAGENT=ON \
  -DWITH_XC_KEESHARE=ON \
  -DWITH_XC_UPDATECHECK=OFF \
  -DWITH_XC_FDOSECRETS=ON \
%if_with asan
  -DWITH_ASAN=ON \
%endif
%if_enabled docs
  -DWITH_XC_DOCS=ON \
%else
  -DWITH_XC_DOCS=OFF \
%endif
%if_with yubikey
  -DWITH_XC_YUBIKEY=ON
%endif

%cmake_build

%check
export LANG=en_US.UTF-8; \
  %ctest --exclude-regex "testcli|testpasskeys"

%install
%cmake_install

%files
%_bindir/*
%_libdir/%name
%_desktopdir/org.%name.KeePassXC.desktop
%_datadir/metainfo/org.%name.KeePassXC.appdata.xml
%_datadir/mime/packages/%name.xml
%_iconsdir/hicolor/*/*/*
%_datadir/%name
%if_enabled docs
%_mandir/man?/*
%endif

%changelog
