%def_disable debug
%def_disable hwloc
%define _group rdma

%define Name KNEM
Name: knem
Summary: High-Performance Intra-Node MPI Communication
Version: 1.1.1
Release: alt1
License: BSD
Group: System/Kernel and hardware
URL: http://runtime.bordeaux.inria.fr/%name
Source: %url/download/%name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: rpm-build-kernel
%{?_enable_hwlock:BuildRequires: pkgconfig(libhwloc)}
BuildRequires: unifdef

%description
%Name is a Linux kernel module enabling high-performance intra-node MPI
communication for large messages. %Name offers support for asynchronous
and vectorial data transfers as well as offloading memory copies on to
Intel I/OAT hardware.


%package tools
Summary: %Name High-Performance Intra-Node MPI Communication tools
Group: System/Kernel and hardware

%description tools
%Name is a Linux kernel module enabling high-performance intra-node MPI
communication for large messages. %Name offers support for asynchronous
and vectorial data transfers as well as offloading memory copies on to
Intel I/OAT hardware.


%package devel
Summary: Files for build with %Name
Group: Development/C
BuildArch: noarch

%description devel
%Name is a Linux kernel module enabling high-performance intra-node MPI
communication for large messages. %Name offers support for asynchronous
and vectorial data transfers as well as offloading memory copies on to
Intel I/OAT hardware.

This package contains header file for build with %Name.


%package devel-doc
Summary: Files for build with %Name
Group: Development/Documentation
BuildArch: noarch

%description devel-doc
%Name is a Linux kernel module enabling high-performance intra-node MPI
communication for large messages. %Name offers support for asynchronous
and vectorial data transfers as well as offloading memory copies on to
Intel I/OAT hardware.

This package contains API docs for build with %Name.


%package -n kernel-source-%name
Summary: %Name module sources for Linux kernel
Group: Development/Kernel
BuildArch: noarch
Provides: kernel-src-%name = %version-%release

%description -n kernel-source-%name
%Name is a Linux kernel module enabling high-performance intra-node MPI
communication for large messages. %Name offers support for asynchronous
and vectorial data transfers as well as offloading memory copies on to
Intel I/OAT hardware.
This package contains %Name module sources for Linux kernel.


%prep
%setup
%patch -p1
install -d -m 0755 %name-%version
cat > %name-%version/Makefile <<"__EOF__"
obj-m += knem.o
knem-objs := knem_main.o

KSRC ?= /lib/modules/`uname -r`/build
KHDR ?= $(KSRC)
KREL ?= dummy

knem.ko: knem_checks.h knem_io.h knem_hal.h knem_config.h knem_main.c
	$(MAKE) -C $(KSRC) M=$(CURDIR) EXTRA_CFLAGS="-include $(CURDIR)/knem_checks.h --include $(CURDIR)/knem_config.h" modules

knem_checks.h: check_kernel_headers.sh
	sh check_kernel_headers.sh knem_checks.h $(KSRC) $(KHDR) $(KREL)
__EOF__
ln -sr driver/linux/*.{c,h,sh} %name-%version/
unifdef -D__KERNEL__ -o %name-%version/%{name}_io.h common/%{name}_io.h || [ $? = 1 ]
unifdef -U__KERNEL__ -o common/%{name}_io.h common/%{name}_io.h  || [ $? = 1 ]


%build
./autogen.sh
%configure \
	--sysconfdir=%_sysconfdir/udev/rules.d \
	%{subst_enable debug} \
	%{subst_enable hwloc} \
	--without-linux \
	--disable-silent-rules
%make_build

ln -s ../common/%{name}_config.h %name-%version/

gzip -9c ChangeLog > ChangeLog.gz


%install
%makeinstall_std docdir=%_docdir/%name-%version
rm -rf %buildroot%_sbindir

install -d -m 0755 %kernel_srcdir
install -p -m 0644 AUTHORS COPYING ChangeLog.* README REPORTING-BUGS TODO %buildroot%_docdir/%name-%version/

tar -cJhf %kernel_srcdir/%name-%version.tar.xz %name-%version


%if 0
%post
%_sbindir/groupadd -r -f %_group &> /dev/null ||:
%endif


%files tools
%doc %_docdir/%name-%version
%exclude %_docdir/%name-%version/%name-api.html
%exclude %_docdir/%name-%version/ChangeLog.*
%_bindir/*
%exclude %_sysconfdir/udev/rules.d/*


%files devel
%_includedir/*


%files devel-doc
%dir %doc %_docdir/%name-%version
%doc %_docdir/%name-%version/%name-api.html
%doc %_docdir/%name-%version/ChangeLog.*


%files -n kernel-source-%name
%_usrsrc/kernel


%changelog
