Name: kodi
Version: 21.2
Release: alt3

Summary: Kodi Media Center
License: GPL-2.0-or-later
Group: Video
Url: https://kodi.tv/

Requires: kodi-bin = %version-%release
Requires: kodi-data = %version-%release
Requires: kodi-x11 = %version-%release

Source0: %name-%version-%release.tar
Source1: groovy.tar

BuildRequires: cmake gcc-c++
BuildRequires: libcrossguid-devel libflatbuffers-devel libgif-devel liblzo2-devel
BuildRequires: libunistring-devel libidn2-devel libEGL-devel
BuildRequires: /proc swig java-devel
BuildRequires: pkgconfig(RapidJSON)
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(bluez)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(dvdnav)
BuildRequires: pkgconfig(dvdread)
BuildRequires: pkgconfig(enca)
BuildRequires: pkgconfig(expat)
BuildRequires: pkgconfig(fmt)
BuildRequires: pkgconfig(fontconfig)
BuildRequires: pkgconfig(fribidi)
BuildRequires: pkgconfig(fstrcmp)
BuildRequires: pkgconfig(gbm)
BuildRequires: pkgconfig(gl)
BuildRequires: pkgconfig(glesv2)
BuildRequires: pkgconfig(glu)
BuildRequires: pkgconfig(gnutls)
BuildRequires: pkgconfig(gtest)
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(lcms2)
BuildRequires: pkgconfig(libass)
BuildRequires: pkgconfig(libavcodec)
BuildRequires: pkgconfig(libavfilter)
BuildRequires: pkgconfig(libavformat)
BuildRequires: pkgconfig(libavutil)
BuildRequires: pkgconfig(libbluray)
BuildRequires: pkgconfig(libcap)
BuildRequires: pkgconfig(libcdio)
BuildRequires: pkgconfig(libcec)
BuildRequires: pkgconfig(libcrypto)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libdisplay-info)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(libdvdcss)
BuildRequires: pkgconfig(libinput)
BuildRequires: pkgconfig(libiso9660)
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(liblircclient0)
BuildRequires: pkgconfig(libmicrohttpd)
BuildRequires: pkgconfig(libnfs)
BuildRequires: pkgconfig(libpcre)
BuildRequires: pkgconfig(libpcrecpp)
BuildRequires: pkgconfig(libpipewire-0.3)
BuildRequires: pkgconfig(libpng)
BuildRequires: pkgconfig(libpostproc)
BuildRequires: pkgconfig(libswresample)
BuildRequires: pkgconfig(libswscale)
BuildRequires: pkgconfig(libtasn1)
BuildRequires: pkgconfig(libudfread)
BuildRequires: pkgconfig(libva)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(libxslt)
BuildRequires: pkgconfig(nettle)
BuildRequires: pkgconfig(p11-kit-1)
BuildRequires: pkgconfig(python3)
BuildRequires: pkgconfig(spdlog)
BuildRequires: pkgconfig(sqlite3)
BuildRequires: pkgconfig(taglib)
BuildRequires: pkgconfig(tinyxml)
BuildRequires: pkgconfig(tinyxml2)
BuildRequires: pkgconfig(udev)
BuildRequires: pkgconfig(uuid)
BuildRequires: pkgconfig(vdpau)
BuildRequires: pkgconfig(wayland-protocols)
BuildRequires: pkgconfig(wayland-client++)
BuildRequires: pkgconfig(xau)
BuildRequires: pkgconfig(xcb)
BuildRequires: pkgconfig(xdamage)
BuildRequires: pkgconfig(xdmcp)
BuildRequires: pkgconfig(xext)
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: pkgconfig(xrandr)
BuildRequires: pkgconfig(xxf86vm)
BuildRequires: pkgconfig(zlib)

%package bin
Summary: Kodi binaries
Group: Video
Requires: kodi-data = %version-%release

%package data
Summary: Kodi architecture-independent data
Group: Video
BuildArch: noarch
Requires: python3(sqlite3)
AutoReqProv: yes,nopython

%package devel
Summary: Kodi development part
Group: Development/C++
Requires: kodi = %version-%release

%package x11
Summary: Kodi X11-specific part
Group: Video
Requires: kodi-bin = %version-%release

%description
Kodi is an media-player and entertainment hub for all your digital media.

%description bin
Kodi is an media-player and entertainment hub for all your digital media.
This package contains Kodi binaries.

%description data
Kodi is an media-player and entertainment hub for all your digital media.
This package contains all architecture-independent data requried for Kodi.

%description devel
Kodi is an media-player and entertainment hub for all your digital media.
This package contains development part of Kodi.

%description x11
Kodi is an media-player and entertainment hub for all your digital media.
This package contains X11-specific part of Kodi.

%define __nprocs 8
%define docdir %_defaultdocdir/%name
%ifarch armh aarch64
%define platdefs -DAPP_RENDER_SYSTEM=gles
%else
%define platdefs -DAPP_RENDER_SYSTEM=gl
%endif

%prep
%setup
tar xf %SOURCE1 -C %_sourcedir
%ifarch %e2k
sed -i "/make_map/s/std::string_view/const char*/g" \
	xbmc/windowing/gbm/WinSystemGbm.cpp \
	xbmc/cores/AudioEngine/Sinks/AESinkStarfish.cpp \
	xbmc/cores/VideoSettings.h xbmc/utils/ColorUtils.h \
	xbmc/cores/VideoPlayer/VideoRenderers/VideoShaders/ShaderFormats.h \
	xbmc/rendering/{gl/RenderSystemGL.h,gles/RenderSystemGLES.h}
sed -i "s/private:/public:/" \
	xbmc/cores/AudioEngine/Sinks/pipewire/Pipewire.h
sed -i "s/HTML_BASIC_COLORS.find(value/&.c_str()/" \
	xbmc/cores/VideoPlayer/DVDSubtitles/DVDSubtitleTagSami.cpp
%endif

%build
%cmake  -DTARBALL_DIR=%_sourcedir \
        -DGIT_VERSION=%release \
        -DCORE_PLATFORM_NAME="x11 wayland gbm" \
        %platdefs
%cmake_build

%install
%cmakeinstall_std
sed -i -e '/Exec=kodi/ s,=,=%_bindir/,' %buildroot%_datadir/xsessions/kodi.desktop
install -pm0644 -D kodi.wmsession %buildroot%_sysconfdir/X11/wmsession.d/20KODI
mkdir %buildroot%_libdir/kodi/addons

%add_python3_req_skip xbmc
%add_python3_req_skip xbmcgui
%add_python3_req_skip xbmcaddon
%add_python3_req_skip xbmcvfs

%files
%docdir
%_desktopdir/kodi.desktop
%_iconsdir/hicolor/*/apps/kodi.png
%_datadir/metainfo/*.xml

%files bin
%_bindir/kodi
%_bindir/kodi-standalone

%dir %_libdir/kodi
%_libdir/kodi/addons
%_libdir/kodi/system
%_libdir/kodi/kodi.bin
%_libdir/kodi/kodi-xrandr

%files data
%dir %_datadir/kodi
%_datadir/kodi/addons
%_datadir/kodi/media
%_datadir/kodi/system
%_datadir/kodi/userdata
%_datadir/kodi/privacy-policy.txt
%_datadir/wayland-sessions/kodi-gbm.desktop

%files devel
%_includedir/kodi
%_datadir/kodi/cmake
%_libdir/kodi/cmake

%files x11
%config(noreplace) %_sysconfdir/X11/wmsession.d/20KODI
%_datadir/xsessions/kodi.desktop

%changelog
