%define rname ktouch

Name: %rname
Version: 25.08.2
Release: alt2
%K6init

Group: Education
Summary: A program for learning touch typing
Url: http://www.kde.org
License: GPL-2.0-or-later or LGPL-2.0-or-later

# QtQuick, QtQuick.Layouts
Requires: libqt6-quick libqt6-quicklayouts
Requires: qml6(Qt5Compat.GraphicalEffects)
Requires: qml6(org.kde.kquickcontrols) qml6(org.kde.charts)
Provides:  kde5-ktouch = %EVR
Obsoletes: kde5-ktouch < %EVR

Source: %rname-%version.tar

BuildRequires(pre): rpm-build-kf6
BuildRequires: extra-cmake-modules
BuildRequires: qt6-declarative-devel
BuildRequires: desktop-file-utils
BuildRequires: libXres-devel libxml2-devel
BuildRequires: libX11-devel libxkbcommon-devel libxkbfile-devel libxcb-devel
BuildRequires: kf6-kcmutils-devel kf6-kcompletion-devel kf6-kdeclarative-devel kf6-kdoctools-devel
BuildRequires: kf6-kitemviews-devel kf6-kpackage-devel kf6-kservice-devel kf6-ktextwidgets-devel kf6-kwindowsystem-devel kf6-kxmlgui-devel
BuildRequires: kf6-kiconthemes-devel
BuildRequires: kqtquickcharts-devel

%description
KTouch is a program for learning touch typing. KTouch is a way to learn
to type on a keyboard quickly and correctly. Every finger has its place
on the keyboard with associated keys to press.

KTouch helps you learn to touch typing by providing you with something
to write. KTouch can also help you to remember what fingers to use.

%prep
%setup -n %rname-%version

%build
%K6build \
    -DCOMPILE_QML=OFF \
    #

%install
%K6install
%K6install_move data ktouch
%find_lang %name --with-kde --all-name

%files -f %name.lang
%doc LICENSES/*
%_K6bin/ktouch
%_K6xdgapp/org.kde.ktouch.desktop
%_K6icon/*/*/apps/ktouch.*
%_K6data/ktouch/
%_K6cfg/ktouch.kcfg
%_datadir/metainfo/*.xml

%changelog
