%define _unpackaged_files_terminate_build 1

# used by mvn_build
%def_without javadoc

%define _localstatedir  %_var

# ldapjdk was renamed dogtag-ldapjdk
%define ldapjdk_rebranded_version 5.2.0-alt1

%define jss_version 5.6.0
%define java_version 21

Name: ldapjdk
Epoch: 1
Version: 5.6.0
Release: alt1

Summary: LDAP SDK
License: MPL-1.1 or GPLv2+ or LGPLv2+
Group: Development/Java
Url: https://github.com/dogtagpki/ldap-sdk
Vcs: https://github.com/dogtagpki/ldap-sdk
Source: %name-%version.tar
Patch: %name-%version-alt.patch

# - upstream doesn't support i586 (Fedora's Java 17 is not built for that arch)
# - ALT's Java 17 is not built for armh
ExcludeArch: %ix86 armh

BuildRequires(pre): rpm-macros-java
BuildRequires: java-devel >= %java_version
BuildRequires: maven-local
BuildRequires: mvn(org.slf4j:slf4j-api)
BuildRequires: mvn(org.slf4j:slf4j-jdk14)
BuildRequires: mvn(org.dogtagpki.jss:jss-base) >= %jss_version

%description
The Mozilla LDAP SDKs enable you to write applications which access,
manage, and update the information stored in an LDAP directory.

%package -n dogtag-ldapjdk
Summary: LDAP SDK
Group: System/Libraries

Provides: ldapjdk = %EVR
Obsoletes: ldapjdk < %ldapjdk_rebranded_version

Requires: dogtag-jss >= %jss_version
Requires: java >= %java_version

%description -n dogtag-ldapjdk
The Mozilla LDAP SDKs enable you to write applications which access,
manage, and update the information stored in an LDAP directory.

%prep
%setup
%patch -p1
# flatten-maven-plugin is not available in RPM
%pom_remove_plugin org.codehaus.mojo:flatten-maven-plugin

# specify Maven artifact locations
%mvn_file org.dogtagpki.ldap-sdk:ldapjdk ldapjdk/ldapjdk ldapjdk
%mvn_file org.dogtagpki.ldap-sdk:ldapbeans ldapjdk/ldapbeans ldapbeans
%mvn_file org.dogtagpki.ldap-sdk:ldapfilter ldapjdk/ldapfilter ldapfilt
%mvn_file org.dogtagpki.ldap-sdk:ldapsp ldapjdk/ldapsp ldapsp
%mvn_file org.dogtagpki.ldap-sdk:ldaptools ldapjdk/ldaptools ldaptools

%build
%mvn_build

%install
%mvn_install

%files -n dogtag-ldapjdk -f .mfiles

%changelog
