Name: lftp
Version: 4.9.2
Release: alt1

Summary: Sophisticated command line file transfer program
License: GPLv3+
Group: Networking/File transfer
Url: http://lftp.yar.ru/

# ftp://ftp.yars.free.net/pub/source/lftp/lftp-%version.tar.xz
Source: lftp-%version.tar

# http://git.altlinux.org/gears/l/lftp.git
Patch: lftp-%version-%release.patch

# Due to default pager.
Requires: less

# Automatically added by buildreq on Thu Jan 02 2003
BuildRequires: gcc-c++ libexpat-devel libncurses-devel libreadline-devel libssl-devel zlib-devel

%description
lftp is sophisticated file transfer program with command-line
interface.  It supports the FTP, HTTP, HTTPS, SFTP, FISH, and
BitTorrent protocols, advanced and obscure features of the protocols,
proxy servers, automatic retries on non-fatal errors and timeouts,
continuation of interrupted file transfers, mirroring, transfer rate
throttling, multiple connections and background jobs, shell-like
command syntax and comprehensive scripting, command-line editing
(via the GNU Readline library), context-sensitive command completion,
command history, and a lot more.

%prep
%setup
%patch -p1
sed -i 's/curses\.h term\.h/term\.h curses\.h/' m4/terminfo.m4
xz -9k NEWS src/ChangeLog

%build
%def_with openssl
%def_with modules
export CXX=%__cxx
%autoreconf
%configure \
	%{subst_with openssl} \
	%{subst_with modules} \
	--with-pager='exec less' \
	--enable-packager-mode \
	#
%make_build

%install
%makeinstall_std MKDIR_P='mkdir -p'
%{?_with_modules:find %buildroot%_libdir/lftp/ -type f -name \*.la -delete}

%find_lang %name
%set_verify_elf_method strict,rpath=normal
%add_findreq_skiplist %_datadir/lftp/convert-mozilla-cookies
%add_findreq_skiplist %_datadir/lftp/verify-file
%define _unpackaged_files_terminate_build 1

%files -f %name.lang
%config(noreplace) %_sysconfdir/lftp.conf
%_bindir/*
%_libdir/liblftp*.so*
%{?_with_modules:%_libdir/lftp}
%_datadir/lftp
%_mandir/man?/*
%doc src/ChangeLog.xz F* MIRRORS NEWS.xz
%doc AUTHORS README.* THANKS TODO BUGS

%changelog
