%define _unpackaged_files_terminate_build 1

%def_enable shared
%def_enable static
%def_disable Werror
%def_disable debug
%def_enable libminimal
%def_disable memory_manager
%def_enable largefile

%define bname aal
Name: lib%bname
Version: 1.0.7
Release: alt2
Summary: Abstraction library for ReiserFS utilities
License: GPLv2
Group: System/Libraries
URL: http://reiser4.sourceforge.net/

Source: %name-%version.tar

%description
This is a library that provides application abstraction mechanism.
It include device abstraction, libc independence code, etc.

%package devel
Summary: Headers and libraries for developing with %name
Group: Development/C
Requires: %name%{?_disable_shared:-devel-static} = %EVR

%description devel
This package includes headers and libraries for developing with the
%name library.

%package devel-static
Summary: Static libraries for developing with %name
Group: Development/C
Requires: %name-devel = %EVR

%description devel-static
This package includes static libraries for developing with the %name
library.

%if_enabled libminimal
%if_enabled shared
%package minimal
Summary: Minimal abstraction library for ReiserFS utilities
Group: System/Libraries

%description minimal
This is a minimal library that provides application abstraction
mechanism. It include device abstraction, libc independence code, etc.

%package minimal-devel
Summary: Headers and libraries for developing with %name-minimal
Group: Development/C
Requires: %name-minimal = %EVR
Requires: %name-devel = %EVR

%description minimal-devel
This package includes the headers and libraries for developing with the
%name-minimal library.
%endif

%if_enabled static
%package minimal-devel-static
Summary: Static libraries for developing with %name-minimal
Group: Development/C
%if_enabled shared
Requires: %name-minimal = %EVR
Requires: %name-devel = %EVR
%endif

%description minimal-devel-static
This package includes static libraries for developing with the
%name-minimal library.
%endif
%endif

%prep
%setup
sed -i -r '/^[[:blank:]]+\.\/run-ldconfig/d' Makefile.am

%build
%autoreconf
%configure \
	--libdir=/%_lib \
	%{subst_enable shared} \
	%{subst_enable static} \
	%{subst_enable debug} \
	%{subst_enable Werror} \
	%{subst_enable largefile} \
	%{subst_enable libminimal} \
	%{subst_enable_to memory_manager memory-manager} \
	%nil

%make_build

%install
%makeinstall_std

# Static libraries and library symlinks not needed to be in %_lib/, relocate them to %_libdir/
install -d  -m 0755 %buildroot{%_libdir,%_docdir/%name-%version}
for f in %buildroot/%_lib/*.so; do
	ln -sf /%_lib/$(readlink -n "$f") "$f"
done
mv %buildroot/%_lib/*.{a,so} %buildroot%_libdir/

install -m 0644 AUTHORS COPYING CREDITS ChangeLog THANKS %buildroot%_docdir/%name-%version/

%if_enabled shared
%files
%doc %_docdir/%name-%version
/%_lib/%name-1.0.so.*
%endif

%files devel
%{?_disable_shared:%doc %_docdir/%name-%version}
%{?_enable_shared:%_libdir/%name.so}
%_includedir/%bname
%_datadir/aclocal/*

%if_enabled static
%files devel-static
%_libdir/%name.a
%endif

%if_enabled libminimal
%if_enabled shared
%files minimal
/%_lib/%name-minimal.so.*

%files minimal-devel
%_libdir/%name-minimal.so
%endif

%if_enabled static
%files minimal-devel-static
%_libdir/%name-minimal.a
%endif
%endif

%changelog
