%def_disable snapshot

%define _name appstream-glib
%define ver_major 0.8
%define namespace AppStreamGlib
%define api_ver 1.0
%define asb_ver 5

%def_disable rpm

%def_enable installed_tests
%def_enable gtk_doc
%def_enable check

Name: lib%_name
Version: %ver_major.3
Release: alt1

Summary: Library for AppStream metadata
Group: System/Libraries
License: LGPL-2.1-or-later
Url: http://www.freedesktop.org/wiki/Distributions/AppStream/

Vcs: https://github.com/hughsie/appstream-glib.git

%if_disabled snapshot
Source: http://people.freedesktop.org/~hughsient/%_name/releases/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

%define glib_ver 2.58
%define curl_ver 7.56
%define json_glib_ver 1.1.2

Requires: shared-mime-info >= 2.3

Obsoletes: appdata-tools < 0.1.9
Provides: appdata-tools = %EVR
Provides: %_bindir/appstream-util
Provides: %_bindir/appstream-builder

Obsoletes: libappstream-builder < 0.9.15
Conflicts: libappstream-builder < 0.9.15

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson glib2-devel >= %glib_ver
BuildRequires: libarchive-devel libcurl-devel >= %curl_ver
BuildRequires: libgdk-pixbuf-devel libpango-devel pkgconfig(gdk-3.0)
BuildRequires: gobject-introspection-devel libgdk-pixbuf-gir-devel
BuildRequires: gtk-doc docbook-utils docbook-dtds
BuildRequires: libyaml-devel gcab libgcab-devel gperf libuuid-devel
BuildRequires: libjson-glib-devel >= %json_glib_ver
BuildRequires: librpm-devel

%description
This library provides GObjects and helper methods to make it easy to read and
write AppStream metadata. It also provides a simple DOM implementation that
makes it easy to edit nodes and convert to and from the standardized XML
representation.

%package devel
Summary: GLib Libraries and headers for %name
Group: Development/C
Requires: %name = %EVR
Obsoletes: libappstream-builder-devel < 0.9.15
Conflicts: libappstream-builder-devel < 0.9.15

%description devel
GLib headers and libraries for appstream-glib.

%package gir
Summary: GObject introspection data for the %_name library
Group: System/Libraries
Requires: %name = %EVR
Obsoletes: libappstream-builder-gir < 0.9.15
Conflicts: libappstream-builder-gir < 0.9.15

%description gir
GObject introspection data for the AppStream metadata library.

%package gir-devel
Summary: GObject introspection devel data for the %_name library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR
Obsoletes: libappstream-builder-gir-devel < 0.9.15
Conflicts: libappstream-builder-gir-devel < 0.9.15

%description gir-devel
GObject introspection devel data for the AppStream metadata library.

%package devel-doc
Summary: Development package for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package provides development documentation for the AppStream
metadata library.

%package tests
Summary: Tests for the %_name package
Group: Development/Other
BuildArch: noarch
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed %_name library.

%prep
%setup -n %_name-%version

%build
%meson \
       %{subst_enable_meson_bool rpm rpm} \
       %{subst_enable_meson_bool gtk_doc gtk-doc}
%nil
%meson_build

%install
%meson_install
%find_lang %_name

%check
%__meson_test -v

%files -f %_name.lang
%_bindir/appstream-util
%_bindir/appstream-compose
%_bindir/appstream-builder
%_libdir/%name.so.*
%dir %_libdir/asb-plugins-%asb_ver
%_libdir/asb-plugins-%asb_ver/*.so
%_man1dir/appstream-util.1.*
%_man1dir/appstream-compose.1.*
%_man1dir/appstream-builder.1.*
%_datadir/bash-completion/completions/appstream-util
%_datadir/bash-completion/completions/appstream-builder
%doc README.md AUTHORS NEWS

%files devel
%_includedir/%name/
%_libdir/%name.so
%_pkgconfigdir/%_name.pc
%_datadir/aclocal/appstream-xml.m4
%_datadir/aclocal/appdata-xml.m4
%_datadir/gettext/its/appdata.its
%_datadir/gettext/its/appdata.loc

%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir

%files devel-doc
%_datadir/gtk-doc/html/%_name/

%if_enabled installed_tests
%files tests
%_datadir/installed-tests/%_name/
%endif


%changelog
