%def_disable snapshot
%define _name bytesize
%def_enable check

Name: lib%_name
Version: 2.11
Release: alt1

Summary: A library for working with sizes in bytes
Group: System/Libraries
License: LGPL-2.1
Url: https://github.com/storaged-project/%name

%if_disabled snapshot
Source: %url/releases/download/%version/%name-%version.tar.gz
%else
Vcs: https://github.com/rhinstaller/libbytesize.git
Source: %name-%version.tar
%endif

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: gtk-doc
BuildRequires: glib2-devel libgmp-devel libmpfr-devel libpcre2-devel
%{?_enable_check:
BuildRequires: python3-module-polib python3-module-pocketlint
BuildRequires:python3-module-pylint python3-module-pycodestyle}

%description
The %name is a C library that facilitates work with sizes in bytes.
Be it parsing the input from users or producing a nice human readable
representation of a size in bytes this library takes localization into
account. It also provides support for sizes bigger than MAXUINT64.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains header files and pkg-config files needed for
development with the %name library.

%package -n python3-module-%_name
Summary: Python 3 bindings for %name
Group: Development/Python3
Requires: %name = %version-%release
Provides: %_bindir/bscalc

%description -n python3-module-%_name
This package contains Python 3 bindings for %name making the use of
the library from Python 3 easier and more convenient.

%prep
%setup -n %name-%version

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std
%find_lang %name

%check
%make check

%files -f %name.lang
%_libdir/%name.so.*
%doc README.md LICENSE
#%doc NEWS*

%files devel
%_includedir/%_name/
%_libdir/%name.so
%_pkgconfigdir/%_name.pc
%_datadir/gtk-doc/html/%name/

%files -n python3-module-%_name
%_bindir/bscalc
%python3_sitelibdir/%_name/*
%_man1dir/bscalc.1*


%changelog
