%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%define oname libdb
%define __soversion_major 5
%define __soversion %{__soversion_major}.3
%define __tclversion 8.6

Summary: The Berkeley DB database library for C
Name: libdb%{__soversion}
Version: 5.3.28
Release: alt5.1
Group: System/Libraries
License: BSD and LGPLv2 and Sleepycat
URL: http://www.oracle.com/database/berkeley-db/

# http://download.oracle.com/berkeley-db/db-%{version}.tar.gz
Source0: db-%{version}.tar
# http://download.oracle.com/berkeley-db/db.1.85.tar.gz
Source1: db.1.85.tar
# For mt19937db.c
# http://www.gnu.org/licenses/lgpl-2.1.txt
Source2: lgpl-2.1.txt
# libdb man pages generated from the 5.3.28 documentation
Source3: libdb-5.3.28-manpages.tar

Patch0: libdb-multiarch.patch
# db-1.85 upstream patches
# http://www.oracle.com/technology/products/berkeley-db/db/update/1.85/patch.1.{1,2,3,4}
Patch10: patch.1.1
Patch11: patch.1.2
Patch12: patch.1.3
Patch13: patch.1.4
# other patches
Patch20: db-1.85-errno.patch
Patch22: db-4.6.21-1.85-compat.patch
Patch24: db-4.5.20-jni-include-dir.patch
# License clarification patch
# http://devel.trisquel.info/gitweb/?p=package-helpers.git;a=blob;f=helpers/DATA/db4.8/007-mt19937db.c_license.patch;h=1036db4d337ce4c60984380b89afcaa63b2ef88f;hb=df48d40d3544088338759e8bea2e7f832a564d48
Patch25: 007-mt19937db.c_license.patch
# memp_stat fix provided by upstream (rhbz#1211871)
Patch27: db-5.3.21-memp_stat-upstream-fix.patch
# fix for mutexes not being released provided by upstream (rhbz#1277887)
Patch28: db-5.3.21-mutex_leak.patch
# fix for overflowing hash variable inside bundled lemon
Patch29: db-5.3.28-lemon_hash.patch
# upstream patch adding the ability to recreate libdb's environment on version mismatch
# or when libpthread.so is modified (rhbz#1394862)
Patch30: db-5.3.28-condition_variable.patch
# additional changes to the upstream patch to address rhbz#1460003
Patch31: db-5.3.28-condition-variable-ppc.patch
# downstream patch that adds a check for rpm transaction lock in order to be able to update libdb
# FIXME: remove when able
Patch32: db-5.3.28-rpm-lock-check.patch
# downstream patch to hotfix rhbz#1464033, sent upstream
Patch33: db-5.3.28-cwd-db_config.patch
Patch34: libdb-5.3.21-region-size-check.patch
# Patch sent upstream
Patch35: checkpoint-opd-deadlock.patch
Patch36: db-5.3.28-atomic_compare_exchange.patch
# CDB race (rhbz #1099509)
Patch37: libdb-cbd-race.patch
# Limit concurrency to max 1024 CPUs (rhbz#1245410)
# A fix for the issue should be in an upstream release already
# https://community.oracle.com/message/13274780#13274780
Patch38: libdb-limit-cpu.patch
# rhbz#1608749 Patch sent upstream
# Expects libdb-5.3.21-mutex_leak.patch applied
Patch39: libdb-5.3.21-trickle_cpu.patch

BuildRequires: gcc gcc-c++
BuildRequires: perl libtool
BuildRequires: tcl-devel >= %{__tclversion}
BuildRequires: chrpath
BuildRequires: zlib-devel

%description
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. The Berkeley DB includes B+tree, Extended
Linear Hashing, Fixed and Variable-length record access methods,
transactions, locking, logging, shared memory caching, and database
recovery. The Berkeley DB supports C, C++, and Perl APIs. It is
used by many applications, including Python and Perl, so this should
be installed on all systems.

%package -n db%{__soversion}-utils
Summary: Command line tools for managing Berkeley DB databases
Group: Databases
Requires: %name = %EVR
Conflicts: db4.7-utils db4.8-utils db6.1-utils
Conflicts: pks-db
Conflicts: db1-utils

%description -n db%{__soversion}-utils
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. Berkeley DB includes B+tree, Extended
Linear Hashing, Fixed and Variable-length record access methods,
transactions, locking, logging, shared memory caching, and database
recovery. DB supports C, C++ and Perl APIs.

%package devel
Summary: C development files for the Berkeley DB library
Group: Development/C
Requires: %name = %EVR
Conflicts: libdb4.7-devel libdb4.8-devel libdb6.1-devel

%description devel
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. This package contains the header files,
libraries, and documentation for building programs which use the
Berkeley DB.

%package devel-doc
Summary: C development documentation files for the Berkeley DB library
Group: Development/Other
Requires: %name = %EVR
Requires: %name-devel = %EVR
BuildArch: noarch

%description devel-doc
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. This package contains the header files,
libraries, and documentation for building programs which use the
Berkeley DB.

%package cxx
Summary: The Berkeley DB database library for C++
Group: System/Libraries
Requires: %name = %EVR

%description cxx
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. The Berkeley DB includes B+tree, Extended
Linear Hashing, Fixed and Variable-length record access methods,
transactions, locking, logging, shared memory caching, and database
recovery. The Berkeley DB supports C, C++, and Perl APIs. It is
used by many applications, including Python and Perl, so this should
be installed on all systems.

%package cxx-devel
Summary: The Berkeley DB database library for C++
Group: Development/C++
Requires: %name-cxx = %EVR
Requires: %name-devel = %EVR
Conflicts: libdb4.7_cxx-devel libdb4.8_cxx-devel libdb6.1_cxx-devel

%description cxx-devel
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. The Berkeley DB includes B+tree, Extended
Linear Hashing, Fixed and Variable-length record access methods,
transactions, locking, logging, shared memory caching, and database
recovery. The Berkeley DB supports C, C++, and Perl APIs. It is
used by many applications, including Python and Perl, so this should
be installed on all systems.

%package tcl
Summary: Development files for using the Berkeley DB with tcl
Group: System/Libraries
Requires: %name = %EVR
Conflicts: libdb4.7_tcl libdb4.8_tcl libdb6.1_tcl

%description tcl
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. This package contains the libraries
for building programs which use the Berkeley DB in Tcl.

%package tcl-devel
Summary: Development files for using the Berkeley DB with tcl
Group: Development/Tcl
Requires: %name-tcl = %EVR
Conflicts: libdb4.7_tcl-devel libdb4.8_tcl-devel libdb6.1_tcl-devel

%description tcl-devel
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. This package contains the libraries
for building programs which use the Berkeley DB in Tcl.

%package sql
Summary: Development files for using the Berkeley DB with sql
Group: System/Libraries
Requires: %name = %EVR

%description sql
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. This package contains the libraries
for building programs which use the Berkeley DB in SQL.

%package sql-devel
Summary: Development files for using the Berkeley DB with sql
Group: Development/Other
Requires: %name-sql = %EVR
Conflicts: libdb6.1_sql-devel
Conflicts: db6.1-utils

%description sql-devel
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. This package contains the libraries
for building programs which use the Berkeley DB in SQL.

%prep
%setup -n db-%version -a 1 -a 3
cp %SOURCE2 .

%patch0 -p1
pushd db.1.85/PORT/linux
%patch10 -p0
popd
pushd db.1.85
%patch11 -p0
%patch12 -p0
%patch13 -p0
%patch20 -p1
popd

%patch22 -p1
%patch24 -p1
%patch25 -p1
%patch27 -p1
%patch28 -p1
%patch29 -p1
%patch30 -p1
%patch31 -p1
%patch32 -p1
%patch33 -p1
%patch34 -p1
%patch35 -p1
%patch36 -p1
%patch37 -p1
%patch38 -p1
%patch39 -p1

cd dist
./s_config
cd ..

%build
CFLAGS="$RPM_OPT_FLAGS -fno-strict-aliasing"
CFLAGS="$CFLAGS -DSHAREDSTATEDIR='\"%{_sharedstatedir}\"' -DSQLITE_ENABLE_COLUMN_METADATA=1 -DSQLITE_DISABLE_DIRSYNC=1 -DSQLITE_ENABLE_FTS3=3 -DSQLITE_ENABLE_RTREE=1 -DSQLITE_SECURE_DELETE=1 -DSQLITE_ENABLE_UNLOCK_NOTIFY=1 -I../../../lang/sql/sqlite/ext/fts3/"
export CFLAGS

source %_libdir/tclConfig.sh
export LIBTSO_LIBS="${TCL_LIBS}"
export LIBCSO_LIBS="-ldl"

# Build the old db-185 libraries.
make -C db.1.85/PORT/%{_os} OORG="$CFLAGS"

test -d dist/dist-tls || mkdir dist/dist-tls
# Static link db_dump185 with old db-185 libraries.
/bin/sh libtool --tag=CC --mode=compile	%{__cc} $RPM_OPT_FLAGS -Idb.1.85/PORT/%{_os}/include -D_REENTRANT -c util/db_dump185.c -o dist/dist-tls/db_dump185.lo
/bin/sh libtool --tag=LD --mode=link %{__cc} -o dist/dist-tls/db_dump185 dist/dist-tls/db_dump185.lo db.1.85/PORT/%{_os}/libdb.a

# Update config files to understand aarch64
for dir in lang/sql/sqlite lang/sql/jdbc lang/sql/odbc; do
  pushd "$dir"
  %autoreconf
  popd
done

pushd dist
sh s_config
popd

pushd dist/dist-tls
%define _configure_script ../configure
%configure -C \
	--disable-rpath \
	--enable-compat185 \
	--enable-dump185 \
	--enable-shared \
	--disable-static \
	--enable-cxx \
	--enable-sql \
	--enable-test \
	--enable-tcl \
	--with-tcl=%_libdir \
	%nil

# Remove libtool predep_objects and postdep_objects wonkiness so that
# building without -nostdlib doesn't include them twice.  Because we
# already link with g++, weird stuff happens if you don't let the
# compiler handle this.
perl -pi -e 's/^predep_objects=".*$/predep_objects=""/' libtool
perl -pi -e 's/^postdep_objects=".*$/postdep_objects=""/' libtool
perl -pi -e 's/-shared -nostdlib/-shared/' libtool

%make_build

# Run some quick subsystem checks
echo "source ../../test/tcl/test.tcl; r env; r mut; r memp" | tclsh
popd

%install
mkdir -p %buildroot%_includedir
mkdir -p %buildroot%_libdir
mkdir -p %buildroot%_man1dir

%makeinstall_std STRIP=/bin/true -C dist/dist-tls

chmod +x %buildroot%_libdir/*.so*

# Move the header files to a subdirectory, in case we're deploying on a
# system with multiple versions of DB installed.
mkdir -p %buildroot%_includedir/%name
mv %buildroot%_includedir/*.h %buildroot%_includedir/%name/

# Create symlinks to includes so that "use <db.h> and link with -ldb" works.
for i in db.h db_cxx.h db_185.h; do
	ln -s %name/$i %buildroot%_includedir
done

# Eliminate installed doco
rm -rf %buildroot%_prefix/docs

# XXX Avoid Permission denied. strip when building as non-root.
chmod u+w %buildroot%_bindir %buildroot%_bindir/*

# remove unneeded .la files (#225675)
rm -f %buildroot%_libdir/*.la

# remove RPATHs
chrpath -d %buildroot%_libdir/*.so %buildroot%_bindir/*

# unify documentation and examples, remove stuff we don't need
rm -rf docs/csharp
rm -rf examples/csharp
rm -rf docs/installation
mv examples docs
mv man/* %buildroot%_man1dir

%files
%doc LICENSE lgpl-2.1.txt
%doc README
%_libdir/libdb-%{__soversion}.so
%_libdir/libdb-%{__soversion_major}.so

%files devel
%_libdir/libdb.so
%dir %_includedir/%name
%_includedir/%name/db.h
%_includedir/%name/db_185.h
%_includedir/db.h
%_includedir/db_185.h

%files devel-doc
%doc docs/*

%files -n db%{__soversion}-utils
%_bindir/db*_archive
%_bindir/db*_checkpoint
%_bindir/db*_deadlock
%_bindir/db*_dump*
%_bindir/db*_hotbackup
%_bindir/db*_load
%_bindir/db*_printlog
%_bindir/db*_recover
%_bindir/db*_replicate
%_bindir/db*_stat
%_bindir/db*_upgrade
%_bindir/db*_verify
%_bindir/db*_tuner
%_man1dir/db_*

%files cxx
%_libdir/libdb_cxx-%{__soversion}.so
%_libdir/libdb_cxx-%{__soversion_major}.so

%files cxx-devel
%_includedir/%name/db_cxx.h
%_includedir/db_cxx.h
%_libdir/libdb_cxx.so

%files tcl
%_libdir/libdb_tcl-%{__soversion}.so
%_libdir/libdb_tcl-%{__soversion_major}.so

%files tcl-devel
%_libdir/libdb_tcl.so

%files sql
%_libdir/libdb_sql-%{__soversion}.so
%_libdir/libdb_sql-%{__soversion_major}.so

%files sql-devel
%_bindir/dbsql
%_libdir/libdb_sql.so
%_includedir/%name/dbsql.h

%changelog
