%def_enable python3

Name: libdnet
Version: 1.16.4
Release: alt1

Summary: A dumb networking library
Group: System/Libraries
License: BSD-3-Clause
Url: https://github.com/ofalk/libdnet

Source: libdnet-%version-%release.tar

## Automatically added by buildreq on Mon Jul 31 2023
## optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config libgpg-error libstdc++-devel perl pkg-config python3 python3-base python3-dev python3-module-pkg_resources sh4
#BuildRequires: gcc-c++ libcheck-devel python3-module-Cython python3-module-setuptools

# The list generated by the buildreq(1) utility was manually divided:
BuildRequires: gcc-c++ libcheck-devel
%{?_enable_python:python3-module-Cython python3-module-setuptools}

%package devel
Summary: Development libdnet library, header files, documentation and examples
Group: Development/C
Requires: %name = %version-%release

%package -n dnet
Summary: A dumb networking library test program
Group: Networking/Other
Requires: %name = %version-%release

%description
libdnet provides a simplified, portable interface to several low-level
networking routines, including network address manipulation, kernel
arp(4) cache and route(4) table lookup and manipulation, network
firewalling, network interface lookup and manipulation, and raw IP
packet and Ethernet frame transmission.

%description devel
libdnet provides a simplified, portable interface to several low-level
networking routines, including network address manipulation, kernel
arp(4) cache and route(4) table lookup and manipulation, network
firewalling, network interface lookup and manipulation, and raw IP
packet and Ethernet frame transmission.

This package contains the development library, it's header files,
documentation and examples needed to develop libdnet-based applications.

%description -n dnet
dnet is a simple test program for the dnet(3) library. It can be used
to compose and transmit network datagrams as a Unix-style filter (e.g.
reading from or writing to files and pipes) or modify the local system
network configuration (including the ARP cache, firewall ruleset,
network interfaces, and routing table).

%package -n python3-module-dnet
Summary: Python bindings for libdnet, a dumb networking library
Group: Development/Python3
Requires: %name = %version-%release

%description -n python3-module-dnet
Python interface for accessing libdnet-provided functions.

%prep
%setup -n libdnet-%version-%release

%build
%autoreconf

export ac_cv_dnet_linux_procfs=yes
%configure \
	--disable-static \
%if_enabled python
	--with-python \
%endif
	#

%make_build

%install
%makeinstall_std

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%files
%_libdir/libdnet.so.1*
%doc LICENSE README.md THANKS TODO

%files devel
%_bindir/dnet-config
%_libdir/libdnet.so
%_includedir/dnet.h
%_includedir/dnet
%_man3dir/dnet.3*

%files -n dnet
%_sbindir/dnet
%_man8dir/dnet.8*

%if_enabled python
%files -n python3-module-dnet
%python3_sitelibdir/dnet-%version-*.egg
%doc python/test.py python/dnet.pyx
%endif

%changelog
