# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
# END SourceDeps(oneline)
Group: Development/Other
%add_optflags %optflags_shared
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       libfli
Version:    1.9.0
Release:    alt1_2
Summary:    Library for FLI CCD Camera & Filter Wheels

License:    BSD
URL:        http://indilib.org/

# Tar is generated from the huge all-in-one tar from INDI
# by using ./libfli-generate-tarball.sh %%{version}
# The main source from upstream is at
# https://github.com/indilib/indi-3rdparty/archive/refs/tags/v%%{version}.tar.gz
Source0:        %{name}-%{version}.tar.gz
Source1:        %{name}-generate-tarball.sh

BuildRequires:  ctest cmake
BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  rpm-macros-systemd
BuildRequires:  pkgconfig(libindi) = %{version}
BuildRequires:  pkgconfig(libusb-1.0)
Source44: import.info

%description
Finger Lakes Instrument library is used by applications to control FLI 
line of CCDs and Filter wheels

%package devel
Group: Development/Other
Summary: Libraries, includes, etc. used to develop an application with %{name}
Requires: %{name} = %{version}-%{release}
%description devel
These are the header files needed to develop a %{name} application

%prep
%setup -q -n %{name}-%{version}
sed -i 's|/lib/udev/rules.d|%{_udevrulesdir}|g' CMakeLists.txt

%build
%{fedora_v2_cmake}
%fedora_v2_cmake_build 

%install
%fedora_v2_cmake_install


%files
%doc --no-dereference LICENSE.BSD
%{_libdir}/*.so.2*
%{_udevrulesdir}/99-fli.rules

%files devel
%{_includedir}/*
%{_libdir}/*.so

%changelog
