%def_disable static

Name: libfreetype
Version: 2.13.2
Release: alt1
Summary: A free and portable font rendering engine
License: FTL or GPLv2+
Group: System/Libraries
Url: http://www.freetype.org/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

PreReq: libharfbuzz
Provides: freetype2 = %version freetype = %version-%release
Obsoletes: freetype2 < %version

Source0: http://download.savannah.gnu.org/releases/freetype/freetype-%version.tar.xz
Source2: http://download.savannah.gnu.org/releases/freetype/freetype-doc-%version.tar.xz
Source1: http://download.savannah.gnu.org/releases/freetype/ft2demos-%version.tar.xz
Source3: ftconfig.h

Patch6: ft2demos-2.6.2-alt-snprintf.patch
Patch11: freetype-2.10.0-enable-subpixel-rendering.patch
Patch12: freetype-2.10.0-enable-valid.patch

BuildRequires(pre): rpm-build-ubt
BuildRequires: bzlib-devel libX11-devel libharfbuzz-devel libpng-devel zlib-devel libpcre-devel libbrotli-devel

%description
The FreeType engine is a free and portable TrueType font rendering
engine, developed to provide TrueType support for a variety of
platforms and environments.  FreeType is a library which can open
and manages font files as well as efficiently load, hint and render
individual glyphs.  FreeType is not a font server or a complete
text-rendering library.

%package devel
Summary: Header files and library for development with FreeType2
Group: Development/C
Requires: %name = %version-%release
# harfbuzz is required in pkg-config file
Requires: libharfbuzz-devel
Provides: freetype2-devel = %version
Obsoletes: freetype2-devel < %version

%description devel
This package contains the header files and development libraries needed
to develop programs that use the FreeType2 library.

%package devel-static
Summary: The FreeType2 static library
Group: Development/C
Requires: %name-devel = %version-%release
Provides: freetype2-devel-static = %version
Obsoletes: freetype2-devel-static < %version

%description devel-static
This package contains the FreeType2 static library.

%package demos
Summary: A collection of FreeType demonstration programs
Group: Development/C
Requires: %name = %version-%release
Provides: freetype2-demos = %version
Obsoletes: freetype2-demos < %version
Conflicts: freetype < %version-%release

%description demos
The FreeType engine is a free and portable TrueType font rendering
engine, developed to provide TrueType support for a variety of
platforms and environments.  FreeType is a library which can open
and manages font files as well as efficiently load, hint and render
individual glyphs.  FreeType is not a font server or a complete
text-rendering library.

This package contains collection of FreeType demonstration programs.

%prep
%setup -n freetype-%version -a1 -b2
ln -s ft2demos-%version ft2demos

%patch6 -p1
%patch11 -p1
%patch12 -p1

%build
%add_optflags -fno-strict-aliasing %(getconf LFS_CFLAGS)
%configure \
	--enable-freetype-config \
	%{subst_enable static}

# get rid of RPATH
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' builds/unix/libtool

%make_build
%make_build -C ft2demos-%version TOP_DIR=..

%install
%make DESTDIR=%buildroot install

for f in ft2demos-%version/bin/.libs/ft*; do
	install -pD -m755 $f %buildroot%_bindir/${f##*/}
done

wordsize=$(echo $(echo -e '#include <bits/wordsize.h>\n__WORDSIZE' | cpp -P))
[ "$wordsize" -ge 32 ]
mv %buildroot%_includedir/freetype2/freetype/config/ftconfig{,-$wordsize}.h
install -pm644 %_sourcedir/ftconfig.h \
	%buildroot%_includedir/freetype2/freetype/config/ftconfig.h

%define docdir %_docdir/%name-%version
%define develdocdir %_docdir/%name-devel-%version
mkdir -p %buildroot%docdir
mkdir -p %buildroot%develdocdir
cp -a docs/* %buildroot%develdocdir/
pushd %buildroot%develdocdir
	bzip2 -9 CHANGES raster.txt
	rm INSTALL* release
popd
mv %buildroot%develdocdir/{FTL.TXT,CHANGES.bz2} %buildroot%docdir/
install -pm644 LICENSE.TXT %buildroot%docdir/

%set_verify_elf_method strict

#triggerin devel -- %name-devel < 2.6.2-alt2
%pre devel
[ ! -L %_includedir/freetype2/freetype ] || \
	rm -f %_includedir/freetype2/freetype

%files
%docdir
%_libdir/*.so.*

%files devel
%develdocdir
%_bindir/*-config
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_datadir/aclocal/*.m4

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%files demos
%_bindir/ft*

%changelog
