%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict
%define soname 3

%def_disable static
%def_enable rust

Name: libgd
Version: 2.3.3
Release: alt6
Summary: A graphics library for drawing image files in various formats
License: GD
Group: Graphics
Url: https://libgd.github.io/
VCS: https://github.com/libgd/libgd.git
Source: %name-%version.tar
Patch1: %name-%version-%release.patch

BuildRequires: fontconfig-devel libXpm-devel libfreetype-devel libjpeg-devel libpng-devel
BuildRequires: libwebp-devel zlib-devel libtiff-devel
%if_enabled rust
BuildRequires: libheif-devel
%endif

# needed for tests
BuildRequires: fonts-ttf-dejavu

%package -n %name%soname
Summary: A graphics library for drawing image files in various formats
Group: System/Libraries

%package -n %name-devel
Summary: Development library and header files for lib%name
Group: Development/C
Requires: %name%soname = %EVR
Provides:  libgd2-devel = %EVR
Provides:  libgd3-devel = %EVR
Conflicts: libgd3-devel < %EVR
Obsoletes: libgd3-devel

%if_enabled static
%package -n %name-devel-static
Summary: Development static library for lib%name
Group: Development/C
Requires: %name-devel = %EVR
%endif

%package utils
Summary: Utilities for drawing image files in various formats
Group: Graphics
Requires: %name%soname = %EVR
Provides:  gd-utils = %EVR
Obsoletes: gd2-utils
Provides:  gd3-utils = %EVR
Conflicts: gd3-utils < %EVR
Obsoletes: gd3-utils

%description
Gd is a graphics library.  It allows your code to quickly draw images
complete with lines, arcs, text, multiple colors, cut and paste from
other images, and flood fills, and write out the result as a PNG or
JPEG file.  This is particularly useful in World Wide Web applications,
where PNG and JPEG are two of the formats accepted for inline images
by most browsers.

Gd is not a paint program.  If you are looking for a paint program, you
are looking in the wrong place.  If you are not a programmer, you are
looking in the wrong place, unless you are installing a required
library in order to run an application.

Gd does not provide for every possible desirable graphics operation.
It is not necessary or desirable for Gd to become a kitchen-sink
graphics package, but version 2.0 does include most frequently
requested features, including both truecolor and palette images,
resampling (smooth resizing of truecolor images) and so forth.

%description -n %name%soname
Gd is a graphics library for drawing image files in various formats.  Gd
allows your code to quickly draw images (lines, arcs, text, multiple colors,
cutting and pasting from other images, flood fills) and write out the result
as a jpeg, png or wbmp file.  Gd is particularly useful in web applications,
where jpeg, png or wbmp files are commonly used as inline images.  Note,
however, that Gd is not a paint program.

%description -n %name-devel
Gd is a graphics library for drawing image files in various formats.  Gd
allows your code to quickly draw images (lines, arcs, text, multiple colors,
cutting and pasting from other images, flood fills) and write out the result
as a jpeg, png or wbmp file.  Gd is particularly useful in web applications,
where jpeg, png or wbmp files are commonly used as inline images.  Note,
however, that Gd is not a paint program.

%if_enabled static
%description -n %name-devel-static
Gd is a graphics library for drawing image files in various formats.  Gd
allows your code to quickly draw images (lines, arcs, text, multiple colors,
cutting and pasting from other images, flood fills) and write out the result
as a jpeg, png or wbmp file.  Gd is particularly useful in web applications,
where jpeg, png or wbmp files are commonly used as inline images.  Note,
however, that Gd is not a paint program.
%endif

%description utils
Gd is a graphics library.  It allows your code to quickly draw images
complete with lines, arcs, text, multiple colors, cut and paste from
other images, and flood fills, and write out the result as a PNG or
JPEG file.  This is particularly useful in World Wide Web applications,
where PNG and JPEG are two of the formats accepted for inline images
by most browsers.

Gd is not a paint program.  If you are looking for a paint program, you
are looking in the wrong place.  If you are not a programmer, you are
looking in the wrong place, unless you are installing a required
library in order to run an application.

Gd does not provide for every possible desirable graphics operation.
It is not necessary or desirable for Gd to become a kitchen-sink
graphics package, but version %version does include most frequently
requested features, including both truecolor and palette images,
resampling (smooth resizing of truecolor images) and so forth.

%prep
%setup
%patch1 -p1

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%autoreconf
%configure --enable-gd-formats %{subst_enable static}
%make_build

%install
%makeinstall_std

%check
%ifarch %ix86 aarch64 ppc64le riscv64 loongarch64
# Tests are known to be buggy on x86 32bit due to rounding issues. See:
# https://github.com/libgd/libgd/issues/359
# https://github.com/libgd/libgd/issues/242
%make_build -k check ||:
%else
%make_build -k check
%endif

%files -n %name%soname
%doc COPYING
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*

%files -n %name-devel
%doc README.md
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc

%if_enabled static
%files -n %name-devel-static
%_libdir/*.a
%endif #static

%files utils
%_bindir/*

%changelog
