%define ver_major 2.30
%def_disable static
%def_disable gtk_doc
%def_enable glade

Name: libgnomecanvas
Version: %ver_major.3
Release: alt2

Summary: GnomeCanvas widget
License: %lgpl2plus
Group: System/Libraries
Url: http://www.gnome.org/
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.bz2

BuildPreReq: rpm-build-gnome rpm-build-licenses intltool

# From configure.in
BuildPreReq: libgtk+2-devel >= 2.6.4
BuildPreReq: libart_lgpl-devel >= 2.3.17
BuildPreReq: libpango-devel >= 1.8.1
%{?_enable_glade:BuildPreReq: libglade-devel >= 2.5.1}

BuildRequires: gtk-doc libgail-devel perl-XML-Parser
BuildRequires: docbook-dtds docbook-style-xsl gtk-doc xsltproc

%description
The canvas widget allows you to create custom displays using stock items
such as circles, lines, text, and so on. It was originally a port of the
Tk canvas widget but has evolved quite a bit over time.

%package devel
Summary: Libraries and headers for libgnomecanvas
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
The canvas widget allows you to create custom displays using stock items
such as circles, lines, text, and so on. It was originally a port of the
Tk canvas widget but has evolved quite a bit over time.

This package contains development libraries and headers files for %name.

%package devel-doc
Summary: Development documentation for GNOME Canvas Widget
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: %name < %version-%release

%description devel-doc
The canvas widget allows you to create custom displays using stock items
such as circles, lines, text, and so on. It was originally a port of the
Tk canvas widget but has evolved quite a bit over time.

This package provides development documentation for %name.

%package devel-static
Summary: Static libraries for libgnomecanvas
Group: Development/GNOME and GTK+
Requires: %name-devel = %version-%release

%description devel-static
The canvas widget allows you to create custom displays using stock items
such as circles, lines, text, and so on. It was originally a port of the
Tk canvas widget but has evolved quite a bit over time.

%prep
%setup -q

%build
#export gnomelocaledir="%_datadir/locale"
%configure \
	%{subst_enable static} \
	%{subst_enable glade} \
	%{?_enable_gtk_doc:--enable-gtk-doc}

%make_build

%install
%makeinstall

%find_lang %name-2.0

%files -f %name-2.0.lang
%_libdir/*.so.*
%_libdir/libglade/2.0/*.so
%doc AUTHORS ChangeLog README NEWS

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files devel-static
%_libdir/*.a
%_libdir/libglade/2.0/*.a
%endif

%exclude %_libdir/libglade/2.0/*.la

%changelog
