%def_disable snapshot
%define xdg_name org.gnome.libgnomekbd

%define ver_major 3.28
%define api_ver 3.0
%def_enable introspection

Name: libgnomekbd
Version: %ver_major.1
Release: alt1

Summary: GNOME keyboard shared library
License: %lgpl2plus
Group: Graphical desktop/GNOME
URL: http://www.gnome.org/

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Obsoletes: gnome-kbd-indicator < 2.22.0
Provides: gnome-kbd-indicator = %version-%release
Provides: %_bindir/gkbd-keyboard-display

%define glib_ver 2.44.0
%define gtk_ver 2.91.6
%define libxklavier_ver 5.2.1

BuildRequires(pre): rpm-macros-meson rpm-build-gnome rpm-build-licenses
BuildRequires: meson libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libxklavier-devel >= %libxklavier_ver
BuildRequires: libX11-devel libXt-devel
%{?_enable_introspection:BuildRequires(pre): rpm-build-gir
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libxklavier-gir-devel}

%description
GNOME keyboard shared library.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
GNOME keyboard shared library.

This is package contain development files for %name.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the GNOME keyboard library

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the GNOME keyboard library

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%check
%__meson_test

%files -f %name.lang
%_libdir/lib*.so.*
%doc AUTHORS NEWS

%_bindir/gkbd-keyboard-display
%_desktopdir/gkbd-keyboard-display.desktop
%_datadir/%name/
%config %_datadir/glib-2.0/schemas/%xdg_name.desktop.gschema.xml
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%config %_datadir/glib-2.0/schemas/%xdg_name.keyboard.gschema.xml
%_datadir/GConf/gsettings/%name.convert

%files devel
%_includedir/%name/
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled introspection
%files gir
%_typelibdir/Gkbd-%api_ver.typelib

%files gir-devel
%_girdir/Gkbd-%api_ver.gir
%endif

%changelog
