%def_disable snapshot
%def_enable utils
%define sover 14
# running nfsd and root priviledges required
%def_disable check

Name: libnfs
Version: 5.0.3
Release: alt1

Summary: NFS client library
License: LGPLv2.1

Group: System/Libraries
Url: https://github.com/sahlberg/%name

%if_disabled snapshot
Source: %url/archive/%name-%version.tar.gz
%else
Vcs: https://github.com/sahlberg/libnfs.git
Source: %name-%version.tar
%endif

%{?_enable_check:BuildRequires(pre):rpm-macros-valgrind
BuildRequires: nfs-server sudo
%ifarch %valgrind_arches
BuildRequires: valgrind
%endif
}

%description
LIBNFS is a client library for accessing NFS shares over a network.

%package devel
Group: Development/C
Summary: NFS client library - development files
Requires: %name = %EVR

%description devel
LIBNFS is a client library for accessing NFS shares over a network.

This package provides libraries and header files for developing
applications that use %name.

%package utils
Summary: Utility programs for LibNFS
Group: Networking/Other
Requires: %name = %EVR

%description utils
This package provides utilities from LibNFS package.


%prep
%setup %{?_disable_snapshot:-n %name-%name-%version}

%build
%autoreconf
%configure --disable-static \
	%{?_disable_utils:--disable-utils}

%install
%makeinstall_std

%check
%make -k VERSION=3 test VERBOSE=1
%make -k VERSION=4 test VERBOSE=1

%files
%_libdir/%name.so.*
%doc README COPYING CHANGELOG

%files devel
%_includedir/nfsc/
%_libdir/%name.so
%_pkgconfigdir/%name.pc

%if_enabled utils
%files utils
%_bindir/nfs-ls
%_bindir/nfs-cat
%_bindir/nfs-cp
%_bindir/nfs-stat
%_man1dir/nfs-ls.1.*
%_man1dir/nfs-cat.1.*
%_man1dir/nfs-cp.1.*
%endif

%changelog
