%define ver_major 0.8
%define api_ver 0.7
%define namespace Notify
%define sover 4

%def_enable introspection
%def_enable gtk_doc
%def_enable docbook_docs
%def_enable check
%def_enable man

Name: libnotify
Version: %ver_major.4
Release: alt1

Summary: Desktop notification library
Group: System/Libraries
License: LGPL-2.1-or-later
Url: http://www.gnome.org

Vcs: https://gitlab.gnome.org/GNOME/libnotify.git

Source: %name-%version.tar
Patch: %name-%version-%release.patch

Provides: %{name}4 = %EVR
Obsoletes: %{name}4

%define glib_ver 2.62

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson libgio-devel >= %glib_ver
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_docbook_docs:BuildRequires: xmlto}
%{?_enable_check:BuildRequires: libgtk+3-devel}
%{?_enable_introspection:
BuildRequires(pre): rpm-build-gir
BuildRequires: gobject-introspection-devel libgdk-pixbuf-gir-devel}
%{?_enable_man:BuildRequires: xsltproc docbook5-style-xsl}

%description
The library that allows applications post notifications on the desktop
in accordance to the proposed Desktop Notification Specification.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR
Provides: %{name}4-devel = %EVR
Obsoletes: %{name}4-devel

%description devel
Files needed to develop applications that use libnotify, a desktop
notification library.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version
Provides: %{name}4-devel-doc = %EVR
Obsoletes: %{name}4-devel-doc

%description devel-doc
API documentation for %name in gtk-doc format.

%package gir
Summary: GObject introspection data for libnotify
Group: System/Libraries
Requires: %name = %EVR
Provides: %{name}4-gir = %EVR
Obsoletes: %{name}4-gir

%description gir
GObject introspection data for the desktop notification library.

%package gir-devel
Summary: GObject introspection devel data for libnotify
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %EVR
Requires: %name-gir = %EVR
Provides: %{name}4-gir-devel = %EVR
Obsoletes: %{name}4-gir-devel

%description gir-devel
GObject introspection devel data for the desktop notification library.

%package -n notify-send
Summary: A program to send desktop notifications
Group: Graphical desktop/GNOME
Requires: %name = %EVR

%description -n notify-send
notify-send sends desktop notifications via a notification daemon from
the command line.

%prep
%setup
%patch -p1

%build
%meson \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    %{subst_enable_meson_feature docbook_docs docbook_docs} \
    %{subst_enable_meson_feature introspection introspection} \
    %{subst_enable_meson_bool check tests} \
    %{subst_enable_meson_bool man man}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_libdir/%name.so.%{sover}*
%doc NEWS

%files -n notify-send
%_bindir/notify-send
%{?_enable_man:%_man1dir/notify-send.1.*}

%files devel
%_libdir/%name.so
%_includedir/%name/
%_pkgconfigdir/%name.pc
%doc NEWS README* %{?_enable_docbook_docs:%__builddir/docs/notification-spec.html}

%if_enabled gtk_doc
%files devel-doc
%_datadir/doc/%name-0/
%endif

%if_enabled introspection
%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir
%endif

%{?_enable_docbook_docs:%exclude %_datadir/doc/%name/}

%changelog
