# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/dot unzip
# END SourceDeps(oneline)
Group: System/Libraries
%add_optflags %optflags_shared
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           libpgf
Version:        7.21.7
Release:        alt1_2
Summary:        PGF (Progressive Graphics File) library

License:        LGPLv2+
URL:            http://www.libpgf.org
Source0:        https://downloads.sourceforge.net/project/%{name}/%{name}/%{version}/libpgf.zip

BuildRequires:  doxygen
BuildRequires:  gcc-c++
BuildRequires:  libtool
Source44: import.info

%description
libPGF contains an implementation of the Progressive Graphics File (PGF)
which is a new image file format, that is based on a discrete, fast
wavelet transform with progressive coding features. PGF can be used
for lossless and lossy compression.

%package        devel
Group: System/Libraries
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%prep
%setup -q -n %{name}

mv README.txt README

# Fix line endings
sed -i -e 's/\r//' configure.ac Makefile.am src/Makefile.am autogen.sh README

sed -i 's|$(DESTDIR)$(datadir)/doc/$(DOC_MODULE)|$(RPM_BUILD_DIR)/libpgf|g' doc/Makefile.am

sh autogen.sh


%build
# FIXME/TODO: document need for -DLIBPGF_DISABLE_OPENMP
# commit 52c998909401f404f1c7029b537ec900f3f780d0 doesn't say why, but
# I *think* it's related to digikam -- rex
export CFLAGS="%{optflags} -DLIBPGF_DISABLE_OPENMP"
export CXXFLAGS="%{optflags} -DLIBPGF_DISABLE_OPENMP -std=c++14"

%configure --disable-static

%make_build


%install
%makeinstall_std




%files
%doc README
%doc --no-dereference COPYING
%{_libdir}/libpgf.so.7*

%files devel
%doc html
%{_includedir}/libpgf/
%{_libdir}/libpgf.so
%{_libdir}/pkgconfig/libpgf.pc
%{_mandir}/man3/*.3*


%changelog
