%define _unpackaged_files_terminate_build 1

Name: libpopt
Version: 1.18
Release: alt1
Epoch: 1

%def_with apidocs

Summary: A C library for parsing command line parameters
License: MIT
Group: System/Libraries
Url: http://www.rpm5.org/

Source: popt.tar

Patch1: popt-1.18-alt-alloc-checks.patch
Patch2: popt-1.18-alt-context-checks.patch
Patch3: popt-1.14-alt-man.patch
Patch4: popt-1.18-alt-poptBadOption.patch
Patch5: popt-1.16-alt-vers.patch
Patch6: popt-1.18-alt-doxygen-src-path.patch

Provides: popt = %version-%release
Obsoletes: popt

%{?_with_apidocs:BuildPreReq: doxygen graphviz fonts-ttf-dejavu}

%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

# Automatically added by buildreq on Thu May 01 2003
BuildRequires: glibc-devel-static

%package devel
Summary: Developement environment for the popt library
Group: Development/C
Provides: popt-devel = %version-%release
Obsoletes: popt-devel
Requires: %name = %EVR
Requires: glibc-devel

%package devel-static
Summary: Static popt library
Group: Development/C
Provides: popt-devel-static = %version-%release
Obsoletes: popt-devel-static
Requires: %name-devel = %EVR

%package doc
Summary: Development documentation for libpopt
Group: Development/C
BuildArch: noarch
Requires: %name-devel = %EVR

%description
Popt is a C library for parsing command line parameters.  Popt was
heavily influenced by the getopt() and getopt_long() functions, but it
improves on them by allowing more powerful argument expansion.  Popt
can parse arbitrary argv[] style arrays and automatically set
variables based on command line arguments.  Popt allows command line
arguments to be aliased via configuration files and includes utility
functions for parsing arbitrary strings into argv[] arrays using
shell-like rules.

%description devel
This package contains developement library, include files and
documentation required for development of popt-based software.

%description devel-static
This package contains static library required for development of
statically linked popt-based software.

%description doc
This package contains developement documentation for libpopt.

%prep
%setup -n popt
%patch1 -p2
%patch2 -p2
%patch3 -p2
%patch4 -p2
%patch5 -p2
%patch6 -p2

%build
%add_optflags -DHAVE_MCHECK_H
gettextize --force --quiet
autoreconf -fisv -I m4
%configure --disable-rpath %{subst_with apidocs}

%make_build

%{?_with_apidocs:make doxygen}

%install
mkdir -p %buildroot/%_lib
%makeinstall_std usrlibdir=%_libdir

# Relocate shared libraries from %_libdir/ to /%_lib/.
for f in %buildroot%_libdir/*.so; do
	t=`objdump -p "$f" |awk '/SONAME/ {print $2}'`
	[ -n "$t" ]
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

%{?_with_apidocs:install -pm644 doxygen/man/man3/{popt.h,poptAlias,poptArg_u,poptContext_s,poptDone_s,poptItem_s,poptOption}.3 %buildroot%_man3dir/}
%define docdir %_docdir/popt-%version
mkdir -p %buildroot%docdir
install -pm644 README CHANGES popt.pdf %buildroot%docdir/
%{?_with_apidocs:cp -a doxygen/html %buildroot%docdir/}

%find_lang popt

%check
%make_build check

%files -f popt.lang
/%_lib/*.so.*

%files devel
%_libdir/*.so
%_pkgconfigdir/*.pc
%_includedir/*
%_mandir/man?/*
%dir %docdir
%docdir/README
%docdir/CHANGES

%files devel-static
%_libdir/*.a

%files doc
%dir %docdir
%{?_with_apidocs:%docdir/html}
%docdir/popt.pdf

%changelog
