Name: libprocps
Version: 3.3.17
Release: alt8.g37f1060

%def_disable devel

%def_disable bootstrap
%if_enabled bootstrap
%force_without systemd
%else
%def_with systemd
%endif

Summary: Compat %name shared library
License: LGPLv2+
Group: System/Libraries
URL: https://gitlab.com/procps-ng/procps

# git://git.altlinux.org/gears/p/procps.git
Vcs: https://gitlab.com/procps-ng/procps.git
Source: %name-%version-%release.tar

%if_with systemd
BuildRequires: libsystemd-devel
%endif

%define _unpackaged_files_terminate_build 1

%description
This package contains %name runtime library.

%if_enabled devel
%package devel
Summary: Development files for building %name-aware applications
License: LGPLv2+
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains development files for building %name-aware
applications.
%endif

%prep
%setup -n %name-%version-%release

# build scripts expect to find package version in this file
echo -n %version-%release > .tarball-version

%build
%add_optflags "-Werror"
./autogen.sh
%configure \
	--disable-static \
	--without-ncurses \
	--disable-kill \
	--disable-skill \
	--disable-pidof \
	--disable-nls \
	--disable-modern-top \
	--disable-pidwait \
	--disable-w \
	%{subst_with systemd} \
	#
%make_build

%install
%makeinstall_std
# relocate shared libraries from %_libdir/ to /%_lib/
for f in %buildroot%_libdir/*.so; do
	t=$(readlink -v "$f")
	ln -snf ../../%_lib/"$t" "$f"
done
mkdir -p %buildroot/%_lib
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

%files
/%_lib/*

%if_enabled devel
%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%else
%exclude %_libdir/*.so
%exclude %_includedir/*
%exclude %_pkgconfigdir/*.pc
%endif

%changelog
