%define _unpackaged_files_terminate_build 1
%def_with zfs
%def_with lz4
%def_enable uv
%def_disable backtrace

Name: libraft
Version: 0.22.1
Release: alt1

Summary: Fully asynchronous C implementation of the Raft consensus protocol.
License: LGPL-3.0-only WITH LGPL-3.0-linking-exception
Group: Development/C

Url: https://github.com/cowsql/%name
Source: %name-%version.tar
Patch: %name-%version.patch

%{?_enable_uv:BuildRequires: pkgconfig(libuv) >= 1.18.0}
%{?_with_lz4:BuildRequires: pkgconfig(liblz4) >= 1.7.1}
%{?_enable_backtrace:BuildRequires: libbacktrace-devel}
BuildRequires: btrfs-progs xfsprogs
%{?_with_zfs:BuildRequires: zfs-utils}
%{?_enable_uv:BuildRequires: libuv-devel >= 1.18.0}

%description
Fully asynchronous C implementation of the Raft consensus protocol.
The library has modular design: its core part implements only the core Raft
algorithm logic, in a fully platform independent way. On top of that, a
pluggable interface defines the I/O implementation for networking (send/receive
RPC messages) and disk persistence (store log entries and snapshots).

%package devel
Summary: Fully asynchronous C implementation of the Raft consensus protocol (development files)
Group: Development/C
Requires: %name = %version-%release

%description devel
Fully asynchronous C implementation of the Raft consensus protocol.
The library has modular design: its core part implements only the core Raft
algorithm logic, in a fully platform independent way. On top of that, a
pluggable interface defines the I/O implementation for networking (send/receive
RPC messages) and disk persistence (store log entries and snapshots).

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
 	%{subst_with lz4} \
	%{subst_enable uv} \
        %{subst_enable backtrace} \
	--disable-static --disable-fixture
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS README.md LICENSE
%_libdir/%name.so.*

%files devel
%_includedir/raft.h
%_includedir/raft/
%_libdir/%name.so
%_pkgconfigdir/raft.pc

%changelog
