# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
BuildRequires: chrpath
Group: System/Libraries
%add_optflags %optflags_shared
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          librfid
Version:       0.2.0
Release:       alt3_22
Summary:       The librfid is a Free Software RFID library

License:       GPLv2
URL:           https://www.openhub.net/p/librfid
Source0:       http://openmrtd.org/projects/librfid/files/librfid-%{version}.tar.bz2

BuildRequires: libusb-compat-devel automake libtool autoconf
Source44: import.info


%description
librfid is a Free Software RFID library. It implements the PCD (reader) 
side protocol stack of ISO 14443 A, ISO 14443 B, ISO 15693, 
Mifare Ultralight and Mifare Classic. Support for iCODE and 
other 13.56MHz based transponders is planned.


%package       devel
Group: Development/Other
Summary:       Development files for %{name}
Requires:      %{name} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%prep
%setup -q



%build
%configure --disable-static
%{make_build}


%install
%{makeinstall_std}
find $RPM_BUILD_ROOT -name '*.la' -delete
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin} -type f -perm -111 ! -name '*.la' `; do
	chrpath -d $i ||:
done





%files
%doc --no-dereference COPYING
%doc README TODO
%{_libdir}/*.so.*
%{_bindir}/librfid-tool
%{_bindir}/mifare-tool
%{_bindir}/librfid-send_script
%{_mandir}/man1/librfid*
%{_mandir}/man1/mifare*

%files devel
%doc README
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/pkgconfig/librfid.pc


%changelog
