Group: System/Libraries
%add_optflags %optflags_shared
%define oldname rtaudio
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           librtaudio
Version:        5.2.0
Release:        alt1_2
Summary:        Real-time Audio I/O Library

License:        MIT
URL:            http://www.music.mcgill.ca/~gary/rtaudio/
Source0:        https://www.music.mcgill.ca/~gary/%{oldname}/release/%{oldname}-%{version}.tar.gz

BuildRequires:  libalsa-devel
BuildRequires:  doxygen
BuildRequires:  gcc-c++
BuildRequires:  libjack-devel
BuildRequires:  libtool
BuildRequires:  libpulseaudio-devel
BuildRequires:  autoconf-archive
Source44: import.info
Patch1: rtaudio-pipewire-jack.patch
Provides: rtaudio = %{version}-%{release}


%description
RtAudio is a set of C++ classes that provide a common API for realtime audio
input/output across different operating systems. RtAudio significantly
simplifies the process of interacting with computer audio hardware. It was
designed with the following objectives:

  * object-oriented C++ design
  * simple, common API across all supported platforms
  * allow simultaneous multi-api support
  * support dynamic connection of devices
  * provide extensive audio device parameter control
  * allow audio device capability probing
  * automatic internal conversion for data format, channel number compensation,
    (de)interleaving, and byte-swapping


%package devel
Group: System/Libraries
Summary:        Real-time Audio I/O Library
Requires:       %{name} = %{version}-%{release}
Provides: rtaudio-devel = %{version}-%{release}

%description devel
RtAudio is a set of C++ classes that provide a common API for realtime audio
input/output across different operating systems. RtAudio significantly
simplifies the process of interacting with computer audio hardware. It was
designed with the following objectives:

  * object-oriented C++ design
  * simple, common API across all supported platforms
  * allow simultaneous multi-api support
  * support dynamic connection of devices
  * provide extensive audio device parameter control
  * allow audio device capability probing
  * automatic internal conversion for data format, channel number compensation,
    (de)interleaving, and byte-swapping


%prep
%setup -n %{oldname}-%{version} -q
%patch1 -p1

# Fix encoding issues
for file in tests/teststops.cpp; do
   sed 's|\r||' $file > $file.tmp
   iconv -f ISO-8859-1 -t UTF8 $file.tmp > $file.tmp2
   touch -r $file $file.tmp2
   mv -f $file.tmp2 $file
done


%build
mkdir -p m4
cp -pt m4 /usr/share/aclocal/ax_cxx_compile_stdcxx.m4
%autoreconf
export CFLAGS="%optflags -fPIC"
%configure --with-jack --with-alsa --with-pulse --enable-shared --disable-static --verbose
%make_build


%install
%makeinstall_std




%files
%doc --no-dereference doc/doxygen/license.txt
%doc README.md doc/release.txt
%{_libdir}/lib%{oldname}.so.*

%files devel
%doc doc/html doc/images
%{_includedir}/%{oldname}/*.h
%{_libdir}/lib%{oldname}.so
%{_libdir}/pkgconfig/%{oldname}.pc


%changelog
