%def_disable snapshot

%define _name libsigc++
%define ver_major 3.6
%define api_ver 3.0
%def_disable docs
%def_enable check

Name: %{_name}3
Version: %ver_major.0
Release: alt1

Summary: The Typesafe Callback Framework for C++
License: LGPL-3.0
Group: System/Libraries
Url: https://libsigcplusplus.github.io/libsigcplusplus/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Vcs: https://github.com/libsigcplusplus/libsigcplusplus.git
Source: %_name-%version.tar
%endif

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ mm-common >= 1.0.4
%{?_enable_docs:BuildRequires: docbook-style-xsl doxygen graphviz xsltproc}

%description
libsigc++ implements a typesafe callback system for standard C++.
It allows you to define signals and to connect those signals to any
callback function, either global or a member function, regardless of
whether it is static or virtual.

%package devel
Summary: Development files for libsigc++ library
Group: Development/C++
Requires: %name = %version-%release

%description devel
This package contains development files for the software development
using libsigc++ library.

%package doc
Summary: Documentation for libsigc++ library
Group: Books/Other
BuildArch: noarch

%description doc
This package provides API documentation of libsigc++ library.

%prep
%setup -n %_name-%version

%build
%{?_disable_snapshot:mm-common-get -f untracked/build_scripts/ untracked/docs/docs}

%meson \
%{?_enable_snapshot:-Dmaintainer-mode=true} \
%{?_enable_docs:-Dbuild-documentation=true}
%nil
%meson_build

%install
%meson_install
%define docdir %_docdir/libsigc++-%api_ver
%{?_disable_docs:mkdir -p %buildroot%docdir}
install -pm644 NEWS README* %buildroot%docdir/

%check
%__meson_test

%files
%_libdir/libsigc-%api_ver.so.*
%dir %docdir
%docdir/[ANR]*

%files devel
%_libdir/libsigc-%api_ver.so
%_libdir/sigc++-%api_ver/
%_includedir/sigc++-%api_ver/
%_pkgconfigdir/sigc++-%api_ver.pc

%files doc
%docdir
%exclude %docdir/[NR]*
%{?_enable_docs:%_datadir/devhelp/books/*}


%changelog
