#https://gitlab.gnome.org/GNOME/libsoup/-/issues/225
%def_disable snapshot

%define _name libsoup
%define ver_major 3.6
%define api_ver 3.0
%define namespace Soup

%def_disable static
%def_enable docs
%def_enable introspection
%def_enable vala
%def_with gssapi
%def_enable brotli
%def_disable debug
%def_disable sysprof
# moved to PyGobject since 3.0.1
%def_disable python
%def_disable check

Name: %_name%api_ver
Version: %ver_major.5
Release: alt1

Summary: HTTP client/server library for GNOME
Group: System/Libraries
License: LGPL-2.0-or-later
Url: https://wiki.gnome.org/Projects/libsoup

Vcs: https://gitlab.gnome.org/GNOME/libsoup.git

%if_enabled snapshot
Source: %_name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%endif

Requires: glib-networking >= 2.70

%define glib_ver 2.70
%define gi_ver 1.33.3
%define psl_ver 0.20.0

BuildRequires(pre): rpm-macros-meson
%{?_enable_python:BuildRequires(pre): rpm-build-python3}
BuildRequires: meson
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libxml2-devel libsqlite3-devel zlib-devel
BuildRequires: docbook-dtds docbook-style-xsl
BuildRequires: xml-common xsltproc
BuildRequires: glib-networking libpsl-devel >= %psl_ver
BuildRequires: libnghttp2-devel
%{?_enable_introspection:BuildRequires(pre): rpm-build-gir
BuildRequires: gobject-introspection-devel >= %gi_ver}
%{?_enable_vala:BuildRequires(pre): rpm-build-vala
BuildRequires: vala-tools}
%{?_with_gssapi:BuildRequires: libkrb5-devel}
%{?_enable_brotli:BuildRequires: libbrotli-devel}
%{?_enable_sysprof:BuildRequires: pkgconfig(sysprof-capture-4)}
%{?_enable_docs:BuildRequires: gi-docgen}
%{?_enable_check:BuildRequires: /proc curl}

%description
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

%package devel
Summary: Headers for HTTP client/server library for GNOME
Group: Development/C
Requires: %name = %EVR

%description devel
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package allows to develop applications that use the Soup library.

%package devel-doc
Summary: Development documentation for HTTP client/server library for GNOME
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package contains development documentation for Soup.

%package devel-static
Summary: Headers for Simple Object Access Protocol static library
Group: Development/C
Requires: %name-devel = %EVR

%description devel-static
This package allows to develop applications that statically linked
against Soup library.

%package gir
Summary: GObject introspection data for the Soup library
Group: System/Libraries
Requires: %name = %EVR

%description gir
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package provides GObject introspection data for the Soup library

%package gir-devel
Summary: GObject introspection devel data for the Soup library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package provides GObject introspection devel data for the Soup library

%package -n python3-module-%name
Summary: GObject introspection devel data for the Soup library
Group: Development/Python3
BuildArch: noarch

%description -n python3-module-%name
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package provides PyGObject overrides for SoupMessageHeaders.

%prep
%setup -n %_name-%version

%build
%ifarch %e2k
%add_optflags -Wno-error=pointer-arith
%endif
%meson \
    %{?_enable_debug:--buildtype=debug} \
    %{?_enable_static:--default-library=both} \
    %{subst_enable_meson_bool gnome gnome} \
    %{subst_enable_meson_feature docs docs} \
    %{subst_enable_meson_feature introspection introspection} \
    %{subst_enable_meson_feature gssapi gssapi} \
    %{subst_enable_meson_feature brotli brotli} \
    %{subst_enable_meson_feature sysprof sysprof}
%nil
%meson_build

%install
%meson_install
%find_lang --output=%_name.lang %_name-%api_ver

%check
%__meson_test

%files -f %_name.lang
%_libdir/%_name-%api_ver.so.*
%doc README NEWS AUTHORS

%files devel
%_includedir/%_name-%api_ver/
%_libdir/%_name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc
%{?_enable_vala:%_vapidir/%_name-%api_ver.vapi}
%{?_enable_vala:%_vapidir/%_name-%api_ver.deps}

%if_enabled docs
%files devel-doc
%_datadir/doc/%_name-%api_ver/
%endif

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%if_enabled introspection
%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir
%endif

%if_enabled python
%files -n python3-module-%name
%python3_sitelibdir_noarch/gi/overrides/Soup.py
%python3_sitelibdir_noarch/gi/overrides/__pycache__/Soup*.pyc
%endif

%changelog
