%define realname soxr
%def_enable check
%def_enable CR32S

Name: lib%realname
Version: 0.1.3
Release: alt1.1

Summary: The SoX Resampler library
Group: System/Libraries
License: LGPLv2+
Url: https://sourceforge.net/p/soxr/wiki/Home/

Vcs: https://github.com/chirlu/soxr.git
#Source: http://downloads.sourceforge.net/%realname/%realname-%version-Source.tar.xz
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake ctest

%description
The SoX Resampler library `libsoxr' performs one-dimensional sample-rate
conversion -- it may be used, for example, to resample PCM-encoded audio.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name%{?_isa} = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -n %name-%version
%patch -p1
%ifarch %e2k
sed -i 's/__x86_64__/__e2k__/' src/pffft.c
sed -i 's/void __cpuidex.*$/#elif 1\n#include <e2kbuiltin.h>/' src/soxr.c
%endif

%build
%cmake	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DCMAKE_INSTALL_PREFIX=%prefix \
	-DCMAKE_CXX_FLAGS:STRING="%optflags" \
	-DLIB_INSTALL_DIR:PATH=%_libdir \
	-DCMAKE_C_FLAGS:STRING="%optflags" \
%ifarch %e2k
	-DWITH_CR64S=FALSE \
%endif
	%{?_disable_CR32S:-DWITH_CR32S=FALSE}
%nil
%cmake_build

%install
%cmake_install

# Remove docs and use the rpmbuild macro instead
rm -rf %buildroot%_docdir/*

%check
%cmake_build -t test

%files
%_libdir/*.so.*
%doc LICENCE NEWS README

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/soxr-lsr.pc
%_pkgconfigdir/soxr.pc
%doc examples

%changelog
