%define _unpackaged_files_terminate_build 1
%def_with check

%global talloc_version 2.4.2

Name: libtevent
Version: 0.16.1
Release: alt1
Summary: The tevent library
License: LGPLv3+
Group: System/Libraries
Url: http://tevent.samba.org/

Source: http://samba.org/ftp/tevent/tevent-%{version}.tar.gz
Patch: tevent-alt-fix-python-ldflags.patch

BuildRequires: libtalloc-devel >= %talloc_version
BuildRequires: zlib-devel
BuildRequires: libcmocka-devel >= 1.1.3

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-talloc-devel >= %talloc_version

Requires: libtalloc >= %talloc_version

%description
Tevent is an event system based on the talloc memory management library.
Tevent has support for many event types, including timers, signals, and
the classic file descriptor events.
Tevent also provide helpers to deal with asynchronous code providing the
tevent_req (Tevent Request) functions.

%package devel
Group: Development/C
Summary: Developer tools for the Tevent library
Requires: %name = %version-%release

%description devel
Header files needed to develop programs that link against the tevent library.

%package -n python3-module-tevent
Group: Development/Python3
Summary: Python3 bindings for the Tevent library
Requires: %name = %EVR

%description -n python3-module-tevent
Python3 bindings for libtevent

%prep
%setup -n tevent-%version
%patch -p1

%build
%undefine _configure_gettext
%configure \
	--disable-rpath \
	--bundled-libraries=NONE \
	--builtin-libraries=replace

%make_build

%install
%makeinstall_std

rm -f %buildroot%_libdir/*.a

%check
# XXX: tests use FD 0, and various input redirections can break
# their assumptions. Let's make sure the input is predictable.
make test < /dev/null

%files
%_libdir/libtevent.so.*

%files devel
%_includedir/tevent.h
%_libdir/libtevent.so
%_pkgconfigdir/tevent.pc

%files -n python3-module-tevent
%python3_sitelibdir/_tevent.cpython*.so
%python3_sitelibdir/tevent.py
%python3_sitelibdir/__pycache__/tevent.*

%changelog
