Name: libtommath
Version: 1.2.1
Release: alt1

Summary: A portable number theoretic multiple-precision integer library
License: WTFPL
Group: System/Libraries

Url: http://www.libtom.net/
# https://github.com/libtom/libtommath.git
Source: ltm-%version.tar.xz

BuildRequires: dblatex ghostscript-utils libtiff-utils

%description
A free open source portable number theoretic multiple-precision integer
library written entirely in C. (phew!). The library is designed to
provide a simple to work with API that provides fairly efficient
routines that build out of the box without configuration.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package doc
Summary: Documentation files for %name
Group: Documentation
Requires: %name = %EVR
BuildArch: noarch

%description doc
The %name-doc package contains PDF documentation for
using %name.

%prep
%setup

# Fix pkgconfig path
sed -i \
    -e 's|^prefix=.*|prefix=%prefix|g' \
    -e 's|^libdir=.*|libdir=%_libdir|g' \
    -e 's|^includedir=.*|includedir=%_includedir|g' \
    %name.pc.in

%build
%make_build V=1 LIBPATH=%_libdir CFLAGS="%optflags -I./" -f makefile.shared
echo "@@@@"
make V=1 -f makefile manual docs

%install
# There is no configure script that ships with libtommath but it does
# understand DESTDIR and it installs via that and the
# INSTALL_USER and INSTALL_GROUP environment variables.
export INSTALL_USER=$(id -un)
export INSTALL_GROUP=$(id -gn)
make install INCPATH=%_includedir/tommath DESTDIR=%buildroot LIBPATH=%_libdir -f makefile.shared
find %buildroot -name '*.la' -exec rm -f {} ';'
find %buildroot -name '*.a' -exec rm -f {} ';'
find %buildroot -name '*.h' -exec chmod 644 {} ';'

%check
make -f makefile.shared test
./test

%files
%doc LICENSE
%_libdir/*.so.*

%files devel
%doc LICENSE
%_includedir/tommath
%_libdir/*.so
%_pkgconfigdir/*.pc

%files doc
%doc LICENSE
%doc doc/bn.pdf
#  doc/poster.pdf doc/tommath.pdf

%changelog
