%define testsdir %{_localstatedir}/%{name}/tests

Name: libtree
Version: 0.10.0
Release: alt1

Summary: C++ lib that helps to work with tree-like data structures
License: GPLv3
Group: Development/C++

Packager: Alexey Appolonov <alexey@altlinux.org>

# http://git.altlinux.org/people/alexey/packages/?p=libtree.git
Source: %{name}-%{version}.tar

BuildRequires: gcc-c++
BuildRequires: libxml++3-devel
BuildRequires: jsoncpp-devel >= 1.8.4

%description
%{summary}.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{name}-devel
Summary: %{name} headers
Group: Development/Other

Requires: %{name}
BuildArch: noarch

Requires: libxml++3-devel
Requires: jsoncpp-devel >= 1.8.4

%description -n %{name}-devel
Development package for %{name}.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{name}-tests
Summary: Tests and test data for %{name}
Group: Other

Requires: %{name}

%description -n %{name}-tests
Tests and test data for %{name}.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{name}-checkinstall
Summary: Tests and test data for %{name}
Group: Other

Requires: %{name}-tests

%description -n %{name}-checkinstall
Package that runs tests in a build environment.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%prep
%setup

%build
%make_build
%make_build -C ./tests

%install
mkdir -p %{buildroot}%{_libdir}
mkdir -p %{buildroot}%{_includedir}/%{name}
mkdir -p %{buildroot}%{_defaultdocdir}/%{name}
mkdir -p %{buildroot}%{testsdir}
# Executables
cp bin/%{name}.so %{buildroot}%{_libdir}
# Includes
cp src/*.h %{buildroot}%{_includedir}/%{name}
# Documentation
cp COPYING %{buildroot}%{_defaultdocdir}/%{name}/
# Tests
cp tests/bin/tests %{buildroot}%{testsdir}
cp -r tests/data %{buildroot}%{testsdir}

%pre -n %{name}-checkinstall
set -e
cd %{testsdir}
./tests data
cd -

%files
%{_libdir}/*.so
%{_defaultdocdir}/%{name}

%files -n %{name}-devel
%{_includedir}/%{name}/

%files -n %{name}-tests
%{testsdir}/*

%files -n %{name}-checkinstall

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%changelog
