%define _unpackaged_files_terminate_build 1
%def_enable libwebpmux
%def_enable libwebpdemux
%def_enable libwebpdecoder
%def_disable sdl
# disabled by default
%def_disable libwebpextras
# https://chromium.googlesource.com/webm/libwebp-test-data required
# see tests/README
%def_disable check
%define sover 7

Name: libwebp
Version: 1.5.0
Release: alt1

Summary: Library and tools for the WebP graphics format
License: BSD-3-Clause
Group: System/Libraries
Url: http://webmproject.org/

Vcs: https://chromium.googlesource.com/webm/libwebp

Source: https://storage.googleapis.com/downloads.webmproject.org/releases/webp/%name-%version.tar.gz

BuildRequires: libgomp-devel libjpeg-devel libpng-devel libtiff-devel
BuildRequires: libgif-devel libfreeglut-devel libSDL2-devel
%{?_enable_sdl:BuildRequires: libSDL-devel}

%description
WebP is an image format that does lossy compression of digital
photographic images. WebP consists of a codec based on VP8, and a
container based on RIFF. Webmasters, web developers and browser
developers can use WebP to compress, archive and distribute digital
images more efficiently.

%package -n %name%sover
Summary: Libraries for the WebP graphics format
Group: System/Libraries
Provides: %name = %EVR
Obsoletes: libwebp = 0.4.0-alt1

%description -n %name%sover
WebP is an image format that does lossy compression of digital
photographic images. WebP consists of a codec based on VP8, and a
container based on RIFF. Webmasters, web developers and browser
developers can use WebP to compress, archive and distribute digital
images more efficiently.

%package devel
Summary: Development files for libwebp, a library for the WebP format
Group: Development/C
Requires: %name%sover = %EVR

%description devel
WebP is an image format that does lossy compression of digital
photographic images. WebP consists of a codec based on VP8, and a
container based on RIFF. Webmasters, web developers and browser
developers can use WebP to compress, archive and distribute digital
images more efficiently.

%package tools
Summary: The WebP command line tools
Group: System/Libraries
Requires: %name%sover = %EVR

%description tools
WebP is an image format that does lossy compression of digital
photographic images. WebP consists of a codec based on VP8, and a
container based on RIFF. Webmasters, web developers and browser
developers can use WebP to compress, archive and distribute digital
images more efficiently.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%ifarch %e2k
# this trick forces WEBP to actually use the SIMD code
# without it the SIMD code is compiled but never used
export CFLAGS="%optflags -DEMSCRIPTEN"
%endif
%configure --disable-static \
    %{subst_enable libwebpmux} \
    %{subst_enable libwebpdemux} \
    %{subst_enable libwebpdecoder} \
    %{subst_enable libwebpextras} \
    %{subst_enable sdl}
%nil
%make_build

%install
%makeinstall_std

%check
%make check

%files -n %name%sover
%_libdir/%name.so.%{sover}*
%_libdir/libsharpyuv.so.*
%{?_enable_libwebpmux:%_libdir/%{name}mux.so.*}
%{?_enable_libwebpdemux:%_libdir/%{name}demux.so.*}
%{?_enable_libwebpdecoder:%_libdir/%{name}decoder.so.*}

%files devel
%dir %_includedir/webp
%_includedir/webp/decode.h
%_includedir/webp/encode.h
%_includedir/webp/types.h
%_includedir/webp/sharpyuv/
%if_enabled libwebpmux
%_includedir/webp/mux.h
%_includedir/webp/mux_types.h
%endif
%{?_enable_libwebpdemux:%_includedir/webp/demux.h}
%_libdir/%name.so
%_libdir/libsharpyuv.so
%{?_enable_libwebpmux:%_libdir/%{name}mux.so}
%{?_enable_libwebpdemux:%_libdir/%{name}demux.so}
%{?_enable_libwebpdecoder:%_libdir/%{name}decoder.so}
%_pkgconfigdir/%name.pc
%_pkgconfigdir/libsharpyuv.pc
%{?_enable_libwebpmux:%_pkgconfigdir/%{name}mux.pc}
%{?_enable_libwebpdemux:%_pkgconfigdir/%{name}demux.pc}
%{?_enable_libwebpdecoder:%_pkgconfigdir/%{name}decoder.pc}

%files tools
%_bindir/cwebp
%_bindir/dwebp
%_man1dir/cwebp.1.*
%_man1dir/dwebp.1.*

%if_enabled libwebpmux
%_bindir/gif2webp
%_bindir/img2webp
%_bindir/webpinfo
%_bindir/webpmux
%_man1dir/gif2webp.1.*
%_man1dir/webpinfo.1.*
%_man1dir/webpmux.1.*
%_man1dir/img2webp.1.*
%endif
%{?_enable_libwebpdemux:%_bindir/vwebp}
%{?_enable_libwebpdemux:%_man1dir/vwebp.1.*}

%changelog
