Name: libwmf
Version: 0.2.13
Release: alt1

Summary: A library to convert wmf files
License: GPLv2
Group: Text tools
Url: https://github.com/caolanm/libwmf
VCS: https://github.com/caolanm/libwmf.git
Requires: fonts-type1-urw
Obsoletes: wmf-fonts < %version-%release

Source: %name-%version.tar
BuildRequires: libICE-devel libexpat-devel libfreetype-devel libgdk-pixbuf-devel libjpeg-devel libpng-devel
BuildRequires: libxml2-devel

%description
%name is a library for unix like machines that can convert wmf
files into other formats, currently it supports a gd binding
to convert to gif, and an X one to draw direct to an X window
or pixmap.

%package -n %{name}lite
Summary: A library to convert wmf files
Group: System/Libraries

%description -n %{name}lite
%{name}lite is a library for unix like machines that can convert wmf
files into other formats, currently it supports a gd binding
to convert to gif, and an X one to draw direct to an X window
or pixmap.

%package -n wmf-utils
Summary: Utilities to convert wmf files
Group: Text tools
Requires: %name = %version-%release

%description -n wmf-utils
This package contains various programs for manipulating files in
the WMF format.

%package -n wmf-gtk-loader
Summary: GDK-pixbuf loader for WMF files
Group: System/Libraries

%description -n wmf-gtk-loader
WMF file loader for the GTK+ image manipulation library, GDK-pixbuf.

%package devel
Summary: A library to convert wmf files - development environment
Group: Development/C
Requires: %name = %version-%release %{name}lite = %version-%release

%description devel
%name is a library for unix like machines that can convert wmf
files into other formats, currently it supports a gd binding
to convert to gif, and an X one to draw direct to an X window
or pixmap.

Install %name-devel if you need to compile an application with %name
support.

%prep
%setup -q

%build
%autoreconf
%configure \
	--with-libxml2 \
	--disable-static \
	--with-gsfontdir=%_datadir/fonts/type1/urw \
	--with-xtrafontmap=%_datadir/%name/fontmap \
	--with-docdir=%_docdir/%name-%version
%make_build

%install
%make DESTDIR=%buildroot install

install -pD -m644 fonts/fontmap %buildroot%_datadir/%name/fontmap

%files
%_libdir/%name-*.so.*
%_datadir/%name

%files -n %{name}lite
%_libdir/%{name}lite-*.so.*

%files -n wmf-utils
%_bindir/wmf2*
%_bindir/libwmf-fontmap

%files -n wmf-gtk-loader
%_libdir/gdk-pixbuf-2.0/*/loaders/*.so

%files devel
%_libdir/*.so
%_bindir/%name-config
%_libdir/pkgconfig/libwmf.pc
%_includedir/%name

%changelog
