%define ver_major 2.31
%def_disable introspection
%def_disable static
%def_disable debug

Name: libwnck
Version: %ver_major.0
Release: alt3

Summary: libwnck is a Window Navigator Construction Kit
License: LGPL-2.0
Group: System/Libraries
Url: http://www.gnome.org

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Provides: %{name}2.22 = %EVR
Provides: %{name}2.20 = %EVR
Obsoletes: %{name}2.22
Obsoletes: %{name}2.20

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

BuildRequires(pre): rpm-build-gnome
# From configure.in
BuildPreReq: intltool >= 0.40.0
BuildPreReq: gnome-common
BuildPreReq: libstartup-notification-devel >= 0.4
BuildPreReq: libX11-devel libXres-devel libXext-devel libXt-devel
BuildPreReq: libgtk+2-devel >= 2.19.7
BuildPreReq: glib2-devel >= 2.16.0
BuildPreReq: gtk-doc >= 1.9
BuildRequires: gobject-introspection-devel
%{?_enable_introspection:BuildRequires(pre): rpm-build-gir
BuildRequires:  libcairo-gobject-devel libgtk+2-gir-devel}

%description
libwnck is Window Navigator Construction Kit, i.e. a library to use for
writing pagers and taskslists and stuff.

This library is a part of the GNOME 2 platform.

%package devel
Summary: Header and development libraries for %name
Group: Development/GNOME and GTK+
Requires: %name = %EVR
Provides: %{name}2.22-devel = %EVR
Provides: %{name}2.20-devel = %EVR
Obsoletes: %{name}2.22-devel
Obsoletes: %{name}2.20-devel

%description devel
This package contains header and development libraries for %name

%package devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package contains development documentation for %name.

%package gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the Window Navigator Construction Kit library

%package gir-devel
Summary: GObject introspection devel data for the %name library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the Window Navigator Construction Kit library

%if_enabled static
%package devel-static
Summary: Static libraries and objects for %name
Group: Development/GNOME and GTK+
Requires: %name-devel = %EVR

%description devel-static
This package contains the General Window Manager interfacing static
libraries and objects.
%endif

%prep
%setup

%build
%autoreconf
%configure \
    %{subst_enable static} \
    %{subst_enable introspection}
%nil
%make_build

%install
%makeinstall_std
# rename tools to avoid conflict with libwnck3
for f in wnckprop wnck-urgency-monitor; do \
mv %buildroot%_bindir/"$f" %buildroot%_bindir/"$f"-2; done

%find_lang %name

%check
%make check

%files -f %name.lang
%_bindir/wnck-urgency-monitor-2
%_bindir/wnckprop-2
%_libdir/*.so.*
%doc AUTHORS NEWS README

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_libdir/girepository-1.0/*

%files gir-devel
%_datadir/gir-1.0/*
%endif

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
