%def_disable static
%define oname zvbi

Name: libzvbi
Version: 0.2.35
Release: alt2

Summary: Raw VBI, Teletext and Closed Caption decoding library

License: GPL
Group: Video
Url: http://zapping.sourceforge.net/

Source: http://prdownloads.sf.net/zapping/%oname-%version.tar.bz2

BuildRequires: doxygen libpng-devel libX11-devel intltool libICE-devel
# for build tests
BuildRequires: gcc-c++

%if_enabled static
BuildRequires: glibc-devel-static
%endif

%description
This library provides routines to

VBI stands for Vertical Blanking Interval, a gap between the image
data transmitted in an analog video signal. This gap is used to
transmit AM modulated data for various data services like Teletext and
Closed Caption.

The zvbi library provides routines to:
* read from raw VBI sampling devices (both V4L and V4L2 API are supported),
* a versatile raw vbi bit slicer,
* decoders for various data services and basic search,
* demodulate raw to sliced VBI data,
* interpret the data of several popular services.
* render and export functions for text pages.

The library is the vbi decoding backbone of the Zapping Gnome TV viewer
and Zapzilla Teletext browser.

%package devel
Summary: Header files for developing apps which will use libzvbi
Group: Development/C
Requires: %name = %version-%release

%description devel
Header files and static library of bzip2 functions, for developing apps which
will use the zvbi library (aka libzvbi)

%if_enabled static
%package devel-static
Summary: Static library for developing apps which will use libzvbi
Group: Development/C
Requires: %name-devel = %EVR

%description devel-static
Static library of bzip2 functions, for developing apps which
will use the zvbi library (aka libzvbi)
%endif

%prep
%setup -n %oname-%version

%build
%autoreconf

%configure \
	%{subst_enable static} \
	--with-x \
	--enable-v4l \
	--enable-dvb \
	--disable-rpath \
	--enable-bktr \
	--enable-proxy \
	--with-libintl-prefix=%prefix

%make_build

%install
%makeinstall_std
%find_lang %oname

%files -f %oname.lang
%doc AUTHORS NEWS README
%_bindir/zvbi*
%_sbindir/zvbi*
%_libdir/libzvbi*.so.*
%_man1dir/zvbi*

%files devel
%doc BUGS ChangeLog TODO doc/html
%_libdir/lib*.so
%_includedir/libzvbi.h
%_pkgconfigdir/zvbi*

%if_enabled static
%files devel-static
%_libdir/lib*.a
%endif

%changelog
