Name: lilv
Version: 0.24.24
Release: alt2

Summary: An LV2 Resource Description Framework Library
License: 0BSD
Group: Sound
Url: https://github.com/lv2/lilv

Source: %name-%version-%release.tar

BuildRequires: gcc-c++ meson rpm-build-python3
BuildRequires: pkgconfig(lv2)
BuildRequires: pkgconfig(serd-0)
BuildRequires: pkgconfig(sndfile)
BuildRequires: pkgconfig(sord-0)
BuildRequires: pkgconfig(sratom-0)
BuildRequires: pkgconfig(zix-0)

%package -n liblilv
Summary: lilv shared libraries
Group: System/Libraries

%package -n liblilv-devel
Summary: Development libraries and headers for lilv
Group: Development/C
Provides: lilv-devel = %EVR
Obsoletes: lilv-devel

%package -n python3-module-lilv
Summary: Python bindings for lilv
Group: Development/Python3
Requires: liblilv == %EVR
BuildArch: noarch

%description
lilv is a library to make the use of LV2 plugins as simple as possible
for applications. Lilv is the successor to SLV2, rewritten to be significantly
faster and have minimal dependencies.

%description -n liblilv
lilv is a lightweight C library for Resource Description Syntax which
supports reading and writing Turtle and NTriples.
This package contains the libraries for lilv.

%description -n liblilv-devel
lilv is a lightweight C library for Resource Description Syntax which
supports reading and writing Turtle and NTriples.
This package contains the headers and development libraries for lilv.

%description -n python3-module-lilv
lilv is a lightweight C library for Resource Description Syntax which
supports reading and writing Turtle and NTriples.
This package contains the python bindings for lilv.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%files
%_bindir/lv2*
%_datadir/bash-completion/completions/lilv
%_man1dir/lv2*.1*

%files -n liblilv
%doc AUTHORS NEWS README.md
%_libdir/liblilv-0.so.*

%files -n liblilv-devel
%_libdir/liblilv-0.so
%_pkgconfigdir/lilv-0.pc
%_includedir/lilv-0

%files -n python3-module-lilv
%python3_sitelibdir_noarch/lilv.*
%python3_sitelibdir_noarch/*/lilv.*

%changelog
